/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VMain;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqLogout
extends Sequence {
    public static final Logger logger = Logger.getLogger(SeqLogout.class);
    private Sequence.SeqResult seqResult;
    private final boolean confirm;

    public SeqLogout(Shell parent, boolean confirm) {
        super(parent);
        this.confirm = confirm;
    }

    @Override
    protected Sequence.SeqResult exec() {
        boolean doLogout = true;
        if (this.confirm) {
            doLogout = GuiUtil.confirmationDialog(this.parent, "Msg.ConfirmLogout");
        }
        if (doLogout) {
            IRunnableWithProgress r = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor p) {
                    p.beginTask(Resources.getMsgString("Logout"), -1);
                    try {
                        Session.closeCurrent();
                        SeqLogout.this.seqResult = Sequence.SeqResult.SeqCompleted;
                        p.done();
                    }
                    catch (SQLException e) {
                        p.done();
                        SeqLogout.this.seqResult = Sequence.SeqResult.SeqFailed;
                        SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Logout"), new Object[0]);
                    }
                }
            };
            Operation.run(this.parent, false, r);
        } else {
            this.seqResult = Sequence.SeqResult.SeqCancelled;
        }
        if (this.seqResult == Sequence.SeqResult.SeqCompleted) {
            DlgMain dlgMain = DlgMain.instance();
            VMain vMain = dlgMain.getVMain();
            dlgMain.updateTitle();
            vMain.getResultComposite().clearAllResults();
            vMain.getPreviewComposite().closeAllTabs();
            dlgMain.setStatusLineMessage("");
        }
        return this.seqResult;
    }
}

