/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MUpdateIsFullyQualified;
import eelk.koguja.dlg.DlgLogin;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomConnection;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.preference.MConnection;
import eelk.koguja.preference.Preferences;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqLogin
extends Sequence {
    public static final String LOGIN_CONGREGATION = "login.congregation";
    public static final Logger logger = Logger.getLogger(SeqLogin.class);
    private DlgLogin dlgLogin;

    public SeqLogin(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        int dlgCode;
        if (this.dlgLogin == null) {
            this.dlgLogin = new DlgLogin(this.modalParent);
        }
        LoadCongsProgress loadCongsProgress = new LoadCongsProgress();
        do {
            if ((dlgCode = this.dlgLogin.open()) != 0) {
                return Sequence.SeqResult.SeqCancelled;
            }
            if (this.dlgLogin.dialogCode == 22) {
                this.dlgLogin.dialogCode = 0;
                return Sequence.SeqResult.SeqCompleted;
            }
            loadCongsProgress.setUserName(this.dlgLogin.getUserName().toLowerCase());
            loadCongsProgress.setPassword(this.dlgLogin.getPassword());
            Operation.run(this.parent, false, loadCongsProgress);
        } while (!loadCongsProgress.getResult().equals((Object)Sequence.SeqResult.SeqCompleted));
        if (loadCongsProgress.getCongs().size() != 1) {
            this.dlgLogin.setCongregations(loadCongsProgress.getCongs());
            if (Preferences.getStore().contains(LOGIN_CONGREGATION)) {
                this.dlgLogin.setDefaultCong(Preferences.getStore().getInt(LOGIN_CONGREGATION));
            }
            dlgCode = this.dlgLogin.open();
            try {
                int congId = this.dlgLogin.getSelectedCongId();
                DomCongregation cong = MCongregation.instance().get(congId);
                Session.current().setCongregation(cong);
                Preferences.getStore().setValue(LOGIN_CONGREGATION, congId);
            }
            catch (SQLException ex) {
                SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("LogIn.Failed"), new Object[0]);
                return Sequence.SeqResult.SeqFailed;
            }
            catch (ObjectNotFound ex) {
                SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("LogIn.Failed"), new Object[0]);
                return Sequence.SeqResult.SeqFailed;
            }
            if (dlgCode != 0) {
                return Sequence.SeqResult.SeqCancelled;
            }
        } else {
            Session.current().setCongregation(loadCongsProgress.getCongs().get(0));
        }
        logger.info("Selected Congregation: " + Session.current().getCongregation());
        return Sequence.SeqResult.SeqCompleted;
    }

    private static class LoadCongsProgress
    implements IRunnableWithProgress {
        private String userName;
        private String password;
        private List<DomCongregation> congs;
        private Sequence.SeqResult result;

        private LoadCongsProgress() {
        }

        public void setUserName(String value) {
            this.userName = value;
        }

        public void setPassword(String value) {
            this.password = value;
        }

        public List<DomCongregation> getCongs() {
            return this.congs;
        }

        public Sequence.SeqResult getResult() {
            return this.result;
        }

        @Override
        public void run(IProgressMonitor p) {
            try {
                p.beginTask(Resources.getMsgString("LogIn.LogIn"), 2);
                p.subTask(Resources.getMsgString("LogIn.CreateSession"));
                DomConnection conn = new DomConnection();
                MConnection.instance().load(conn);
                MConnection.instance().init(conn);
                Session.createSession(conn, this.userName, this.password);
                p.worked(1);
                p.subTask(Resources.getMsgString("LoadingCongregations"));
                this.congs = MCongregation.listMyCongregations();
                p.worked(1);
                p.subTask(Resources.getMsgString("UpdateIsFullyQualified"));
                MUpdateIsFullyQualified.UpdateIsFullyQualified();
                p.worked(1);
                p.done();
                this.result = Sequence.SeqResult.SeqCompleted;
            }
            catch (SQLException e) {
                p.done();
                SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("LogIn.EstablishDBConnection"), new Object[0]);
                this.result = Sequence.SeqResult.SeqFailed;
            }
        }
    }
}

