/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.search.PersonResult;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VResult;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqFindRelatives
extends Sequence {
    private static final Logger logger = Logger.getLogger(SeqFindRelatives.class);
    private final int personId;
    private final int levelOfRelationship;
    private List<PersonResult> result;
    private final VResult vResult;
    private PersonResult personResult;

    public SeqFindRelatives(Shell parent, VResult resultPane, int personId, int level) {
        super(parent);
        this.personId = personId;
        this.levelOfRelationship = level;
        this.vResult = resultPane;
    }

    public void setPersonResult(PersonResult value) {
        if (value.getId() != this.personId) {
            return;
        }
        this.personResult = value;
    }

    @Override
    protected Sequence.SeqResult exec() {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getString("Msg.SeqSearch.performingSearch"), -1);
                try {
                    SeqFindRelatives.this.result = MPersonSwt.instance().findRelatives(SeqFindRelatives.this.personId, SeqFindRelatives.this.levelOfRelationship);
                    if (SeqFindRelatives.this.personResult != null && !SeqFindRelatives.this.result.contains(SeqFindRelatives.this.personResult)) {
                        SeqFindRelatives.this.result.add(0, SeqFindRelatives.this.personResult);
                    }
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Search"), new Object[0]);
                }
            }
        };
        Operation.run(this.parent, true, r);
        this.vResult.setResults(this.result, VResult.ResultMode.ClearExisting);
        return Sequence.SeqResult.SeqCompleted;
    }
}

