/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.action.AFileExport;
import eelk.koguja.dao.MAttribute;
import eelk.koguja.dao.MBaptism;
import eelk.koguja.dao.MCitizenship;
import eelk.koguja.dao.MConfirmation;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDonation;
import eelk.koguja.dao.MFuneral;
import eelk.koguja.dao.MNationality;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MReligion;
import eelk.koguja.dao.MWedding;
import eelk.koguja.dlg.DlgFileDialog;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomAttribute;
import eelk.koguja.model.DomBaptism;
import eelk.koguja.model.DomCitizenship;
import eelk.koguja.model.DomConfirmation;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonationWithTypeName;
import eelk.koguja.model.DomFuneral;
import eelk.koguja.model.DomNationality;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomReligion;
import eelk.koguja.model.DomWedding;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.Result;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.VMain;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqExport
extends Sequence {
    private static final int EXPORT_YEARS = 12;
    final List<Result> results;
    String fileName;

    public SeqExport(Shell parent, List<Result> results) {
        super(parent);
        this.results = results;
    }

    @Override
    protected Sequence.SeqResult exec() {
        DlgFileDialog dlg = new DlgFileDialog(this.parent, 8192);
        dlg.setFilterNames(new String[]{Resources.getString("FileDialog.CSVFiles"), Resources.getString("FileDialog.AllFiles")});
        dlg.setFilterExtensions(new String[]{"*.txt", "*.*"});
        dlg.setFileName("export.txt");
        this.fileName = dlg.open();
        if (this.fileName != null) {
            IRunnableWithProgress r = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor p) {
                    int len = SeqExport.this.results == null ? -1 : SeqExport.this.results.size();
                    p.beginTask(Resources.getMsgString("Save.Saving"), len);
                    SeqExport.this.ExportData(p);
                    p.done();
                }
            };
            Operation.run(this.parent, true, r);
            return Sequence.SeqResult.SeqCompleted;
        }
        return Sequence.SeqResult.SeqCancelled;
    }

    private void ExportData(IProgressMonitor p) {
        try {
            PrintStream file = new PrintStream(new FileOutputStream(this.fileName));
            VMain.SearchMode mode = DlgMain.instance().getVMain().getMode();
            DomPerson person = null;
            file.print(Resources.getString("export.lastname") + "\t" + Resources.getString("export.firstname") + "\t" + Resources.getString("export.maidenname") + "\t" + Resources.getString("export.code") + "\t" + Resources.getString("export.sex") + "\t" + Resources.getString("export.dateofbirth") + "\t" + Resources.getString("export.placeofbirth") + "\t" + Resources.getString("export.dateofdeath") + "\t" + Resources.getString("export.phone") + "\t" + Resources.getString("export.email") + "\t" + Resources.getString("export.maritalstatus") + "\t" + Resources.getString("export.profession") + "\t" + Resources.getString("export.nationality") + "\t" + Resources.getString("export.citizenship") + "\t" + Resources.getString("export.congregation") + "\t" + Resources.getString("export.religion") + "\t" + Resources.getString("export.membercard") + "\t" + Resources.getString("export.book") + "\t" + Resources.getString("export.page") + "\t" + Resources.getString("export.comment") + "\t" + Resources.getString("export.address.street") + "\t" + Resources.getString("export.address.city") + "\t" + Resources.getString("export.address.postcode") + "\t" + Resources.getString("export.address.county") + "\t" + Resources.getString("export.address.country") + "\t" + Resources.getString("export.spouse") + "\t" + Resources.getString("export.children") + "\t" + Resources.getString("export.baptism") + "\t" + Resources.getString("export.confirmation") + "\t" + Resources.getString("export.wedding") + "\t" + Resources.getString("export.funeral"));
            int year = Integer.parseInt(MDonation.getLastYear()) + 1;
            file.print("\t" + year + "\t" + (year - 1) + "\t" + (year - 2) + "\t" + (year - 3) + "\t" + (year - 4) + "\t" + (year - 5) + "\t" + (year - 6) + "\t" + (year - 7) + "\t" + (year - 8) + "\t" + (year - 9));
            for (DomAttribute attribute : MAttribute.listAttributes()) {
                file.print("\t" + attribute.getName());
            }
            file.println();
            for (Result result : this.results) {
                try {
                    if (mode.equals((Object)VMain.SearchMode.PERSON)) {
                        person = MPersonSwt.instance().get(result.getId());
                    } else if (mode.equals((Object)VMain.SearchMode.BAPTISM)) {
                        person = MPersonSwt.instance().get(MBaptism.instance().get(result.getId()).getPersonId());
                    } else if (mode.equals((Object)VMain.SearchMode.CONFIRMATION)) {
                        person = MPersonSwt.instance().get(MConfirmation.instance().get(result.getId()).getPersonId());
                    } else if (mode.equals((Object)VMain.SearchMode.WEDDING)) {
                        person = MPersonSwt.instance().get(MWedding.instance().get(result.getId()).getBrideId());
                        this.exportPersonData(person, file);
                        person = MPersonSwt.instance().get(MWedding.instance().get(result.getId()).getGroomId());
                    } else if (mode.equals((Object)VMain.SearchMode.FUNERAL)) {
                        person = MPersonSwt.instance().get(MFuneral.instance().get(result.getId()).getPersonId());
                    } else if (mode.equals((Object)VMain.SearchMode.DONATION)) {
                        if (MDonation.instance().get(result.getId()).getPersonId() != null) {
                            person = MPersonSwt.instance().get(MDonation.instance().get(result.getId()).getPersonId());
                        } else {
                            p.worked(1);
                            continue;
                        }
                    }
                    this.exportPersonData(person, file);
                    p.worked(1);
                }
                catch (SQLException e) {
                    SwtExceptionHandler.instance().Ex(e, Logger.getLogger(AFileExport.class), Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    SwtExceptionHandler.instance().Ex(e, Logger.getLogger(AFileExport.class), Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
            file.close();
        }
        catch (FileNotFoundException e) {
            SwtExceptionHandler.instance().Ex(e, Logger.getLogger(AFileExport.class), Resources.getErrString("Save.File"), new Object[0]);
        }
        catch (SQLException e) {
            SwtExceptionHandler.instance().Ex(e, Logger.getLogger(AFileExport.class), Resources.getErrString("Load"), new Object[0]);
        }
    }

    private void exportPersonData(DomPerson person, PrintStream out) throws SQLException, ObjectNotFound {
        DomBaptism dbaptism;
        String lastName = person.getLastName() != null ? person.getLastName() : "";
        String firstName = person.getFirstName() != null ? person.getFirstName() : "";
        String maidenName = person.getMaidenName() != null ? person.getMaidenName() : "";
        String code = person.getCode() != null ? person.getCode() : "";
        String sex = "";
        if (person.getSex() != null) {
            sex = person.getSex() == 0 ? Resources.getString("export.sex.male") : Resources.getString("export.sex.female");
        }
        String birthDate = (person.getBirthDate() != null ? person.getBirthDate().toString() : "") + (person.getBirthDateFuzzyEnd() != null ? "-" + person.getBirthDateFuzzyEnd() : "");
        String birthPlace = person.getBirthPlace() != null ? person.getBirthPlace() : "";
        String deathDate = (person.getDeathDate() != null ? person.getDeathDate().toString() : "") + (person.getDeathDateFuzzyEnd() != null ? "-" + person.getDeathDateFuzzyEnd() : "");
        String phone = person.getPhone() != null ? person.getPhone() : "";
        String email = person.getEmail() != null ? person.getEmail() : "";
        Integer maritalStatusID = person.getMaritalStatus();
        String maritalStatus = "";
        if (maritalStatusID != null) {
            switch (maritalStatusID) {
                case 0: {
                    maritalStatus = Resources.getString("export.maritalStatus.single");
                    break;
                }
                case 1: {
                    maritalStatus = Resources.getString("export.maritalStatus.married");
                    break;
                }
                case 2: {
                    maritalStatus = Resources.getString("export.maritalStatus.divorced");
                    break;
                }
                case 3: {
                    maritalStatus = Resources.getString("export.maritalStatus.widow");
                    break;
                }
                case 4: {
                    maritalStatus = Resources.getString("export.maritalStatus.commonlaw");
                    break;
                }
                default: {
                    maritalStatus = "";
                }
            }
        }
        String profession = person.getProfession() != null ? person.getProfession() : "";
        DomNationality dnationality = null;
        if (person.getNationalityId() != null) {
            dnationality = MNationality.instance().get(person.getNationalityId());
        }
        String nationality = dnationality != null ? dnationality.getName() : "";
        Integer citizenshipId = MPersonSwt.instance().getCitizenshipId(person.getId());
        DomCitizenship dCitizenship = null;
        if (citizenshipId != null) {
            dCitizenship = MCitizenship.instance().get(citizenshipId);
        }
        String citizenship = dCitizenship != null ? dCitizenship.getName() : "";
        Integer congregationId = MPersonSwt.instance().getCongregation(person.getId());
        DomCongregation dcongregation = null;
        if (congregationId != null) {
            dcongregation = MCongregation.instance().get(congregationId);
        }
        String congregation = dcongregation != null ? dcongregation.getName() : "";
        DomReligion dreligion = null;
        if (person.getReligionId() != null) {
            dreligion = MReligion.instance().get(person.getReligionId());
        }
        String religion = dreligion != null ? dreligion.getName() : "";
        String memberCard = person.getMembercard() != null ? person.getMembercard() : "";
        String book = person.getBook() != null ? person.getBook() : "";
        String page = person.getPage() != null ? person.getPage() : "";
        String comment = Util.d(person.getComment()).replace('\r', ' ').replace('\n', ' ');
        String street = "";
        String city = "";
        String postcode = "";
        String county = "";
        String country = "";
        DomAddress address = MPersonSwt.instance().getPersonsActiveAddress(person.getId());
        if (address != null) {
            street = (address.getStreet() != null ? address.getStreet() : "") + (address.getHouse() != null ? " " + address.getHouse() : "");
            city = address.getCity() != null ? address.getCity() : "";
            postcode = address.getPostcode() != null ? address.getPostcode() : "";
            county = address.getCounty() != null ? address.getCounty() : "";
            country = address.getCountry() != null ? address.getCountry() : "";
        }
        List<DomPerson> dchildren = MPersonSwt.instance().getChildren(person.getId());
        StringBuilder children = new StringBuilder();
        for (DomPerson dchild : dchildren) {
            children.append(dchild.getLastName()).append(" ").append(dchild.getFirstName()).append(", ");
        }
        if (children.length() > 2) {
            children = new StringBuilder(children.substring(0, children.length() - 2));
        }
        String baptism = (dbaptism = MBaptism.getBaptismForPerson(person.getId())) != null ? (dbaptism.getEventDate() != null ? dbaptism.getEventDate().toString() : "") + (dbaptism.getEventFuzzyDate() != null ? "-" + dbaptism.getEventFuzzyDate().toString() : "") : "";
        DomConfirmation dconfirmation = MConfirmation.getConfirmationForPerson(person.getId());
        String confirmation = dconfirmation != null ? (dconfirmation.getEventDate() != null ? dconfirmation.getEventDate().toString() : "") + (dconfirmation.getEventFuzzyDate() != null ? "-" + dconfirmation.getEventFuzzyDate().toString() : "") : "";
        DomWedding dwedding = MWedding.getWeddingForPerson(person.getId());
        String wedding = dwedding != null ? (dwedding.getEventDate() != null ? dwedding.getEventDate().toString() : "") + (dwedding.getEventFuzzyDate() != null ? "-" + dwedding.getEventFuzzyDate().toString() : "") : "";
        DomFuneral dfuneral = MFuneral.getFuneralForPerson(person.getId());
        String funeral = dfuneral != null ? (dfuneral.getEventDate() != null ? dfuneral.getEventDate().toString() : "") + (dfuneral.getEventFuzzyDate() != null ? "-" + dfuneral.getEventFuzzyDate().toString() : "") : "";
        DomPerson dspouse = MPersonSwt.instance().getSpouse(person.getId());
        String spouse = dspouse != null ? dspouse.getLastName() + " " + dspouse.getFirstName() : "";
        BigDecimal[] donationsSums = this.sumDonationsByYear(MDonation.listMyDonations(person.getId()));
        String[] donations = new String[12];
        for (int i = 0; i < 12; ++i) {
            donations[i] = donationsSums[i] != null ? Math.round(donationsSums[i].doubleValue()) + "" : "";
        }
        Hashtable<Integer, Boolean> attributes = new Hashtable<Integer, Boolean>();
        List<DomAttribute> dattributes = MPersonSwt.getAttributes(person.getId());
        for (DomAttribute attribute : dattributes) {
            attributes.put(attribute.getId(), true);
        }
        out.print(lastName + "\t" + firstName + "\t" + maidenName + "\t" + code + "\t" + sex + "\t" + birthDate + "\t" + birthPlace + "\t" + deathDate + "\t" + phone + "\t" + email + "\t" + maritalStatus + "\t" + profession + "\t" + nationality + "\t" + citizenship + "\t" + congregation + "\t" + religion + "\t" + memberCard + "\t" + book + "\t" + page + "\t" + comment + "\t" + street + "\t" + city + "\t" + postcode + "\t" + county + "\t" + country + "\t" + spouse + "\t" + children + "\t" + baptism + "\t" + confirmation + "\t" + wedding + "\t" + funeral);
        for (String donation : donations) {
            out.print("\t" + donation);
        }
        for (DomAttribute attribute : MAttribute.listAttributes()) {
            out.print("\t" + (attributes.get(attribute.getId()) != null ? Resources.getString("export.hasAttribute") : ""));
        }
        out.println();
    }

    private BigDecimal[] sumDonationsByYear(List<DomDonationWithTypeName> donations) throws NumberFormatException, SQLException {
        BigDecimal[] result = new BigDecimal[12];
        Calendar cal = Calendar.getInstance();
        int currentYear = Integer.parseInt(MDonation.getLastYear()) + 1;
        for (DomDonationWithTypeName donation : donations) {
            cal.setTime(donation.getDonationDate());
            if (currentYear - 12 >= cal.get(1) || cal.get(1) > currentYear || donation.getAmount() == null) continue;
            if (result[currentYear - cal.get(1)] != null) {
                result[currentYear - cal.get((int)1)] = result[currentYear - cal.get(1)].add(donation.getAmount());
                continue;
            }
            result[currentYear - cal.get((int)1)] = donation.getAmount();
        }
        return result;
    }
}

