/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.dlg.DlgMain;
import eelk.koguja.dlg.DlgRelationship;
import eelk.koguja.search.Result;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.DbUtil;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.view.VMain;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class SeqEstRelationship
extends Sequence {
    private DlgRelationship dlgRelationship;

    public SeqEstRelationship(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        List<Result> persons = DlgMain.instance().getVMain().getSelectedResults(VMain.SearchMode.PERSON);
        if (persons.size() != 2) {
            GuiUtil.informationDialog(this.parent, "Err.Relationship.IllegalNumberOfPersons", new Object[0]);
            return Sequence.SeqResult.SeqFailed;
        }
        if (!DbUtil.checkUserCong(IDbUtil.Permission.Write, this.parent)) {
            return Sequence.SeqResult.SeqFailed;
        }
        if (this.dlgRelationship == null) {
            this.dlgRelationship = new DlgRelationship(this.modalParent);
        }
        this.dlgRelationship.create();
        this.dlgRelationship.getView().setPerson1Id(persons.get(0).getId());
        this.dlgRelationship.getView().setPerson2Id(persons.get(1).getId());
        this.dlgRelationship.open();
        return Sequence.SeqResult.SeqCompleted;
    }
}

