/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dao.MDonation;
import eelk.koguja.events.BusinessObjectEventFactory;
import eelk.koguja.model.DomDonation;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqDelete;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.DbUtil;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;

public class SeqDeleteDonation
extends SeqDelete {
    public static final Logger logger = Logger.getLogger(SeqDeleteDonation.class);

    public SeqDeleteDonation(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        for (Result r : this.getObjects()) {
            if (DbUtil.checkUserDonation(IDbUtil.Permission.Delete, r.getId(), GuiUtil.activeShell())) continue;
            return Sequence.SeqResult.SeqFailed;
        }
        if (!GuiUtil.confirmationDialog(this.parent, "Msg.Delete.Donation")) {
            return Sequence.SeqResult.SeqCancelled;
        }
        try {
            for (Result r : this.getObjects()) {
                MDonation.instance().delete(r.getId());
            }
            Session.connection().commit();
        }
        catch (SQLException ex) {
            Session.rollback();
            SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Delete"), new Object[0]);
            return Sequence.SeqResult.SeqFailed;
        }
        catch (ObjectNotFound ex) {
            Session.rollback();
            SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
            return Sequence.SeqResult.SeqFailed;
        }
        this.notifyDeletedListeners();
        return Sequence.SeqResult.SeqCompleted;
    }

    @Override
    protected void notifyDeletedListeners() {
        for (Result r : this.getObjects()) {
            DomDonation p = new DomDonation();
            p.setId(r.getId());
            BusinessObjectEventFactory.notifyDeleteListeners(p);
        }
    }
}

