/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.MessageResult;
import org.eclipse.swt.widgets.Shell;

public abstract class SeqCanSave<D extends BusinessObject>
extends Sequence {
    protected static final SaveAction DEFAULT_SAVE_ACTION = SaveAction.Save;
    private D object;
    private SaveAction saveAction;

    public SeqCanSave(Shell parent) {
        super(parent);
    }

    public D getObject() {
        return this.object;
    }

    public void setObject(D value) {
        this.object = value;
    }

    public SaveAction getSaveAction() {
        return this.saveAction == null ? DEFAULT_SAVE_ACTION : this.saveAction;
    }

    protected void setSaveAction(SaveAction value) {
        if (value == null) {
            return;
        }
        this.saveAction = value;
    }

    protected SaveAction warn(String msgkey) {
        MessageResult mr = GuiUtil.warningDialog(this.parent, "Msg." + msgkey, ((BusinessObject)this.object).getModified_by(), ((BusinessObject)this.object).getModified_on());
        if (mr == MessageResult.Yes) {
            return SaveAction.Save;
        }
        if (mr == MessageResult.No) {
            return SaveAction.Skip;
        }
        return SaveAction.Cancel;
    }

    public static enum SaveAction {
        Save,
        Skip,
        Cancel;

    }
}

