/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.search;

import eelk.koguja.model.DomWedding;
import eelk.koguja.search.Result;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class WeddingResult
extends Result {
    public String docNr;
    public int state;
    public Date date;
    public Time start;
    public Time end;
    public String brideLastName;
    public String brideFirstName;
    public String groomLastName;
    public String groomFirstName;

    public WeddingResult(DomWedding wedding) {
        this.setId(wedding.getId());
        this.docNr = wedding.getDocNr();
        this.state = wedding.getState() != null ? wedding.getState() : 0;
        this.date = wedding.getApplicationDate();
        this.start = wedding.getEventStart();
        this.end = wedding.getEventEnd();
        this.brideLastName = wedding.getBrideLastName();
        this.brideFirstName = wedding.getBrideFirstName();
        this.groomLastName = wedding.getGroomLastName();
        this.groomFirstName = wedding.getGroomFirstName();
    }

    public WeddingResult(ResultSet rs) throws SQLException {
        super(rs);
        this.setId(rs.getInt(1));
        this.docNr = rs.getString(2);
        this.state = rs.getInt(3);
        this.date = rs.getDate(4);
        this.start = rs.getTime(5);
        this.end = rs.getTime(6);
        this.brideLastName = rs.getString(7);
        this.brideFirstName = rs.getString(8);
        this.groomLastName = rs.getString(9);
        this.groomFirstName = rs.getString(10);
    }

    public static List<WeddingResult> fromResultSet(ResultSet rs) throws SQLException {
        ArrayList<WeddingResult> list = new ArrayList<WeddingResult>();
        while (rs.next()) {
            list.add(new WeddingResult(rs));
        }
        return list;
    }

    public static String getFields() {
        return "id, doc_nr, state, event_date, event_end, event_start, bride_lastname, bride_firstname, groom_lastname, groom_firstname ";
    }
}

