/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.search;

import eelk.koguja.dao.MPerson;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomPerson;
import eelk.koguja.search.Result;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PersonResult
extends Result {
    public String lastName;
    public String firstName;
    public String street;
    public String house;
    public String postCode;
    public String city;
    public String county;
    public String age;

    public PersonResult(DomPerson person, DomAddress address) {
        this.setId(person.getId());
        this.lastName = person.getLastName();
        this.firstName = person.getFirstName();
        this.age = MPerson.getAge(person);
        if (address == null) {
            this.street = null;
            this.house = null;
            this.postCode = null;
            this.city = null;
            this.county = null;
        } else {
            this.street = address.getStreet();
            this.house = address.getHouse();
            this.postCode = address.getPostcode();
            this.city = address.getCity();
            this.county = address.getCounty();
        }
    }

    public PersonResult(ResultSet rs) throws SQLException {
        super(rs);
        this.setId(rs.getInt(1));
        this.lastName = rs.getString(2);
        this.firstName = rs.getString(3);
        this.street = rs.getString(4);
        this.house = rs.getString(5);
        this.postCode = rs.getString(6);
        this.city = rs.getString(7);
        this.county = rs.getString(8);
        DomPerson tempPerson = new DomPerson();
        tempPerson.setBirthDate(rs.getDate(9));
        tempPerson.setBirthDateFuzzyEnd(rs.getDate(10));
        tempPerson.setDeathDate(rs.getDate(11));
        tempPerson.setDeathDateFuzzyEnd(rs.getDate(12));
        this.age = MPerson.getAge(tempPerson);
    }

    public static String getFields() {
        return "id, lastname, firstname, street, house, postcode, city, county, birthdate, birthdate_fuzzy_end, deathdate, deathdate_fuzzy_end";
    }

    public static List<PersonResult> fromResultSet(ResultSet rs) throws SQLException {
        ArrayList<PersonResult> list = new ArrayList<PersonResult>();
        while (rs.next()) {
            list.add(new PersonResult(rs));
        }
        return list;
    }
}

