/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.search;

import eelk.koguja.dao.MAttribute;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MGroup;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomGroup;
import eelk.koguja.search.CriterionBln;
import eelk.koguja.search.CriterionDdt;
import eelk.koguja.search.CriterionFlt;
import eelk.koguja.search.CriterionInt;
import eelk.koguja.search.CriterionStr;
import eelk.koguja.search.IndividualEventExpression;
import eelk.koguja.util.Resources;
import java.util.Calendar;
import java.util.StringTokenizer;

public class PersonExpression
extends IndividualEventExpression {
    public static final String P_ATTR_DELIM = ",";
    public final CriterionStr code;
    public final CriterionInt congregation;
    public CriterionBln fullMember;
    public final CriterionBln fullMemberThisYear;
    public final CriterionBln fullMemberLastYear;
    public final CriterionInt dayOfBirthFrom;
    public final CriterionInt monthOfBirthFrom;
    public final CriterionInt dayOfBirthTo;
    public final CriterionInt monthOfBirthTo;
    public final CriterionStr city;
    public final CriterionStr postcode;
    public final CriterionStr comment;
    public final CriterionStr positiveAttributes;
    public final CriterionStr negativeAttributes;
    public final CriterionInt group;
    public final CriterionFlt donationFrom;
    public final CriterionFlt donationTo;
    public final CriterionDdt donationDateFrom;
    public final CriterionDdt donationDateTo;
    public final CriterionInt donationType;
    public final CriterionDdt deathDateFrom;
    public final CriterionDdt deathDateTo;
    public final CriterionInt eventType;
    public final CriterionDdt eventDateFrom;
    public final CriterionDdt eventDateTo;

    public PersonExpression() {
        this.lastName = new CriterionStr("lastname", Resources.getString("VPersonSearchAdvanced.lblSurename"));
        this.addCriterion(this.lastName);
        this.firstName = new CriterionStr("firstname", Resources.getString("VPersonSearchAdvanced.lblGivenName"));
        this.addCriterion(this.firstName);
        this.code = new CriterionStr("code", Resources.getString("VPersonSearchAdvanced.lblIdNumber"));
        this.addCriterion(this.code);
        this.congregation = new CriterionInt("congregation", Resources.getString("VPersonSearchAdvanced.lblCongregation")){

            @Override
            public String toString() {
                DomCongregation c = MCongregation.instance().getCashed((Integer)this.getValue());
                if (c == null) {
                    return "";
                }
                return this.getUserName() + "=" + c.getName();
            }
        };
        this.addCriterion(this.congregation);
        int currentYear = Calendar.getInstance().get(1);
        String fullMemberPrefix = currentYear - 1 + " ";
        this.fullMemberLastYear = new CriterionBln(fullMemberPrefix + " fullmember", fullMemberPrefix + Resources.getString("VPersonSearchAdvanced.chkFullMember")){

            @Override
            public String toString() {
                if (!((Boolean)this.getValue()).booleanValue()) {
                    return "";
                }
                return this.getUserName() + "=" + Resources.getGenString(this.encode((Boolean)this.getValue()));
            }
        };
        this.fullMemberLastYear.setValue(false);
        this.addCriterion(this.fullMemberLastYear);
        fullMemberPrefix = currentYear + " ";
        this.fullMemberThisYear = new CriterionBln(fullMemberPrefix + " fullmember", fullMemberPrefix + Resources.getString("VPersonSearchAdvanced.chkFullMember")){

            @Override
            public String toString() {
                if (!((Boolean)this.getValue()).booleanValue()) {
                    return "";
                }
                return this.getUserName() + "=" + Resources.getGenString(this.encode((Boolean)this.getValue()));
            }
        };
        this.fullMemberThisYear.setValue(false);
        this.addCriterion(this.fullMemberThisYear);
        this.ageFrom = new CriterionInt("agefrom", Resources.getString("VPersonSearchAdvanced.criAgeFrom"));
        this.addCriterion(this.ageFrom);
        this.ageTo = new CriterionInt("ageTo", Resources.getString("VPersonSearchAdvanced.criAgeTo"));
        this.addCriterion(this.ageTo);
        this.dayOfBirthFrom = new CriterionInt("dayofbirthfrom", Resources.getString("VPersonSearchAdvanced.criDayOfBirthFrom"));
        this.addCriterion(this.dayOfBirthFrom);
        this.monthOfBirthFrom = new CriterionInt("monthofbirthfrom", Resources.getString("VPersonSearchAdvanced.criMonthOfBirthFrom"));
        this.addCriterion(this.monthOfBirthFrom);
        this.dayOfBirthTo = new CriterionInt("dayofbirthto", Resources.getString("VPersonSearchAdvanced.criDayOfBirthTo"));
        this.addCriterion(this.dayOfBirthTo);
        this.monthOfBirthTo = new CriterionInt("monthofbirthto", Resources.getString("VPersonSearchAdvanced.criMonthOfBirthTo"));
        this.addCriterion(this.monthOfBirthTo);
        this.city = new CriterionStr("city", Resources.getString("VPersonSearchAdvanced.lblPlace"));
        this.addCriterion(this.city);
        this.postcode = new CriterionStr("postcode", Resources.getString("VPersonSearchAdvanced.lblPostal"));
        this.addCriterion(this.postcode);
        this.comment = new CriterionStr("comment", Resources.getString("VPersonSearchAdvanced.lblNotes"));
        this.addCriterion(this.comment);
        this.sex = new CriterionInt("sex", Resources.getString("VPersonSearchAdvanced.lblSex")){

            @Override
            public String toString() {
                if ((Integer)this.getValue() == 0) {
                    return this.getUserName() + "=" + Resources.getGenString("Male");
                }
                return this.getUserName() + "=" + Resources.getGenString("Female");
            }
        };
        this.addCriterion(this.sex);
        this.positiveAttributes = new CriterionStr("positiveattributes", Resources.getString("VPersonSearchAdvanced.criAttrPos")){

            @Override
            public String toString() {
                StringBuilder result = new StringBuilder(this.getUserName() + "=");
                StringTokenizer st = new StringTokenizer((String)this.getValue(), ";");
                if (!st.hasMoreTokens()) {
                    return "";
                }
                while (st.hasMoreTokens()) {
                    int i = Integer.parseInt(st.nextToken());
                    result.append(MAttribute.instance().getCashed(i)).append(PersonExpression.P_ATTR_DELIM);
                }
                return result.substring(0, result.length() - 1);
            }
        };
        this.addCriterion(this.positiveAttributes);
        this.negativeAttributes = new CriterionStr("negativeattributes", Resources.getString("VPersonSearchAdvanced.criAttrNeg")){

            @Override
            public String toString() {
                StringBuilder result = new StringBuilder(this.getUserName() + "=");
                StringTokenizer st = new StringTokenizer((String)this.getValue(), ";");
                if (!st.hasMoreTokens()) {
                    return "";
                }
                while (st.hasMoreTokens()) {
                    int i = Integer.parseInt(st.nextToken());
                    result.append(MAttribute.instance().getCashed(i)).append(PersonExpression.P_ATTR_DELIM);
                }
                return result.substring(0, result.length() - 1);
            }
        };
        this.addCriterion(this.negativeAttributes);
        this.group = new CriterionInt("group", Resources.getString("VPersonSearchAdvanced.lblGroup")){

            @Override
            public String toString() {
                DomGroup g = MGroup.instance().getCashed((Integer)this.getValue());
                if (g == null) {
                    return "";
                }
                return this.getUserName() + "=" + g.getName();
            }
        };
        this.addCriterion(this.group);
        this.donationFrom = new CriterionFlt("donationfrom", Resources.getString("VPersonSearchAdvanced.criDonationFrom"));
        this.addCriterion(this.donationFrom);
        this.donationTo = new CriterionFlt("donationTo", Resources.getString("VPersonSearchAdvanced.criDonationTo"));
        this.addCriterion(this.donationTo);
        this.donationDateFrom = new CriterionDdt("donationdatefrom", Resources.getString("VPersonSearchAdvanced.criDonationDateFrom"));
        this.addCriterion(this.donationDateFrom);
        this.donationDateTo = new CriterionDdt("donationdateTo", Resources.getString("VPersonSearchAdvanced.criDonationDateTo"));
        this.addCriterion(this.donationDateTo);
        this.donationType = new CriterionInt("donationType", Resources.getString("VPersonSearchAdvanced.criDonationType"));
        this.deathDateFrom = new CriterionDdt("deathdatefrom", Resources.getString("VPersonSearchAdvanced.criDeathDateFrom"));
        this.addCriterion(this.deathDateFrom);
        this.deathDateTo = new CriterionDdt("deathdateTo", Resources.getString("VPersonSearchAdvanced.criDeathDateTo"));
        this.addCriterion(this.deathDateTo);
        this.eventType = new CriterionInt("eventtype", Resources.getString("VPersonSearchAdvanced.lblEventType"));
        this.addCriterion(this.congregation);
        this.eventDateFrom = new CriterionDdt("eventdatefrom", Resources.getString("VPersonSearchAdvanced.criEventDateFrom"));
        this.addCriterion(this.eventDateFrom);
        this.eventDateTo = new CriterionDdt("eventdateto", Resources.getString("VPersonSearchAdvanced.criEventDateTo"));
        this.addCriterion(this.eventDateTo);
    }

    @Override
    protected int getType() {
        return 5;
    }
}

