/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.search;

import eelk.koguja.Session;
import eelk.koguja.search.BaptismExpression;
import eelk.koguja.search.ConfirmationExpression;
import eelk.koguja.search.Criterion;
import eelk.koguja.search.DonationExpression;
import eelk.koguja.search.FuneralExpression;
import eelk.koguja.search.PersonExpression;
import eelk.koguja.search.WeddingExpression;
import eelk.koguja.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class Expression {
    public static final String P_DELIMITER = ";";
    public static final String P_SET = "=";
    public static final String P_ESCAPE = "%";
    protected final Map<String, Criterion<?>> criteria = new HashMap();

    public static String escapeChars(String input) {
        String result = input;
        result = result.replace(P_ESCAPE, "%%");
        result = result.replace(P_SET, "%=");
        result = result.replace(P_DELIMITER, "%;");
        return result;
    }

    public static String restoreChars(String input) {
        String result = input;
        result = result.replace("%%", P_ESCAPE);
        result = result.replace("%=", P_SET);
        result = result.replace("%;", P_DELIMITER);
        return result;
    }

    public static Expression getExpression(Session.SearchMode m) {
        if (m == Session.SearchMode.PERSON) {
            return new PersonExpression();
        }
        if (m == Session.SearchMode.BAPTISM) {
            return new BaptismExpression();
        }
        if (m == Session.SearchMode.CONFIRMATION) {
            return new ConfirmationExpression();
        }
        if (m == Session.SearchMode.FUNERAL) {
            return new FuneralExpression();
        }
        if (m == Session.SearchMode.DONATION) {
            return new DonationExpression();
        }
        if (m == Session.SearchMode.WEDDING) {
            return new WeddingExpression();
        }
        return null;
    }

    public Map<String, Criterion<?>> getCriteria() {
        return this.criteria;
    }

    public void addCriterion(Criterion<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("Criteria cannot be null");
        }
        this.criteria.put(c.getSystemName(), c);
    }

    public void decode(String s) {
        int begin = 0;
        int pos = s.indexOf(P_DELIMITER, begin);
        while (pos != -1) {
            int localBegin;
            while (String.valueOf(s.charAt(pos - 1)).equals(P_ESCAPE)) {
                pos = s.indexOf(P_DELIMITER, pos + 1);
            }
            String currentPair = s.substring(begin, pos);
            int pos2 = currentPair.indexOf(P_SET, localBegin = 0);
            if (String.valueOf(s.charAt(pos2 - 1)).equals(P_ESCAPE)) {
                pos2 = s.indexOf(P_SET, pos2 + 1);
            }
            String currentSysName = currentPair.substring(0, pos2);
            String currentValue = Expression.restoreChars(currentPair.substring(pos2 + 1));
            Criterion<?> cri = this.criteria.get(currentSysName);
            if (cri != null) {
                cri.setEncodedValue(currentValue);
            }
            begin = pos + 1;
            pos = s.indexOf(P_DELIMITER, begin);
        }
    }

    public String encode() {
        StringBuilder result = new StringBuilder();
        Set<String> keySet = this.criteria.keySet();
        for (String systemName : keySet) {
            Criterion<?> c = this.criteria.get(systemName);
            if (c.getValue() == null) continue;
            result.append(Expression.escapeChars(c.getSystemName())).append(P_SET).append(Expression.escapeChars(c.getEncodedValue())).append(P_DELIMITER);
        }
        return result.toString();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        Set<String> keySet = this.criteria.keySet();
        for (String systemName : keySet) {
            Criterion<?> c = this.criteria.get(systemName);
            if (c.getValue() == null || Util.c(c.toString()) == null) continue;
            result.append(c.toString()).append(P_DELIMITER);
        }
        if (Util.c(result.toString()) == null) {
            return "";
        }
        return result.substring(0, result.length() - 1);
    }
}

