/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.search;

import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MEventLocation;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomEventLocation;
import eelk.koguja.model.DomEventState;
import eelk.koguja.search.CriterionDdt;
import eelk.koguja.search.CriterionInt;
import eelk.koguja.search.CriterionStr;
import eelk.koguja.search.CriterionTim;
import eelk.koguja.search.Expression;
import eelk.koguja.util.Resources;

public abstract class EventExpression
extends Expression {
    public final CriterionInt congregation = new CriterionInt("congregation", Resources.getString("VEventSearchAdvanced.lblCongregation")){

        @Override
        public String toString() {
            DomCongregation congregation = MCongregation.instance().getCashed((Integer)this.getValue());
            if (congregation == null) {
                return "";
            }
            return this.getUserName() + "=" + congregation.getName();
        }
    };
    public final CriterionStr documentNumberFrom;
    public final CriterionStr documentNumberTo;
    public final CriterionInt state;
    public final CriterionInt stateExcept;
    public final CriterionDdt appDateStart;
    public final CriterionDdt appDateEnd;
    public final CriterionDdt eventDateStart;
    public final CriterionDdt eventDateEnd;
    public final CriterionTim eventTimeStart;
    public final CriterionTim eventTimeEnd;
    public final CriterionInt place;
    public final CriterionStr participantFirstName;
    public final CriterionStr participantLastName;

    public EventExpression() {
        this.addCriterion(this.congregation);
        this.documentNumberFrom = new CriterionStr("documentNumberFrom", Resources.getString("VEventSearchAdvanced.criDocumentNumberFrom"));
        this.addCriterion(this.documentNumberFrom);
        this.documentNumberTo = new CriterionStr("documentNumberTo", Resources.getString("VEventSearchAdvanced.criDocumentNumberTo"));
        this.addCriterion(this.documentNumberTo);
        this.participantFirstName = new CriterionStr("participantFirstName", Resources.getString("VEventSearchAdvanced.lblParticipantFirstName"));
        this.addCriterion(this.participantFirstName);
        this.participantLastName = new CriterionStr("participantLastName", Resources.getString("VEventSearchAdvanced.lblParticipantLastName"));
        this.addCriterion(this.participantLastName);
        this.state = new CriterionInt("state", Resources.getString("VEventSearchAdvanced.lblState")){

            @Override
            public String toString() {
                return this.getUserName() + "=" + DomEventState.nameOf(EventExpression.this.getType(), (Integer)this.getValue());
            }
        };
        this.addCriterion(this.state);
        this.stateExcept = new CriterionInt("stateexcept", Resources.getString("VEventSearchAdvanced.lblStateExcept")){

            @Override
            public String toString() {
                return this.getUserName() + "=" + DomEventState.nameOf(EventExpression.this.getType(), (Integer)this.getValue());
            }
        };
        this.addCriterion(this.stateExcept);
        this.appDateStart = new CriterionDdt("appdatestart", Resources.getString("VEventSearchAdvanced.criAppDateStart"));
        this.addCriterion(this.appDateStart);
        this.appDateEnd = new CriterionDdt("appdateend", Resources.getString("VEventSearchAdvanced.criAppDateEnd"));
        this.addCriterion(this.appDateEnd);
        this.eventDateStart = new CriterionDdt("eventdatestart", Resources.getString("VEventSearchAdvanced.criEventDateStart"));
        this.addCriterion(this.eventDateStart);
        this.eventDateEnd = new CriterionDdt("eventdateendt", Resources.getString("VEventSearchAdvanced.criEventDateEnd"));
        this.addCriterion(this.eventDateEnd);
        this.eventTimeStart = new CriterionTim("eventtimestart", Resources.getString("VEventSearchAdvanced.criEventTimeStart"));
        this.addCriterion(this.eventTimeStart);
        this.eventTimeEnd = new CriterionTim("eventtimeend", Resources.getString("VEventSearchAdvanced.criEventTimeEnd"));
        this.addCriterion(this.eventTimeEnd);
        this.place = new CriterionInt("place", Resources.getString("VEventSearchAdvanced.lblPlace")){

            @Override
            public String toString() {
                DomEventLocation l = MEventLocation.instance().getCashed((Integer)this.getValue());
                if (l == null) {
                    return "";
                }
                return this.getUserName() + "=" + l.getName();
            }
        };
        this.addCriterion(this.place);
    }

    protected abstract int getType();
}

