/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.search;

import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonation;
import eelk.koguja.model.DomDonationType;
import eelk.koguja.search.Result;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DonationResult
extends Result {
    public String docNr;
    public String lastName;
    public String firstName;
    public String group;
    public String type;
    public String congregation;
    public BigDecimal amount;
    public Date date;

    public DonationResult(DomDonation donation, DomDonationType type, DomCongregation cong) {
        this.setId(donation.getId());
        this.docNr = donation.getDocNr();
        this.lastName = donation.getPersonLastName();
        this.firstName = donation.getPersonFirstName();
        this.group = donation.getGroupName();
        this.type = type != null ? type.toString() : null;
        this.congregation = cong != null ? cong.toString() : null;
        this.amount = donation.getAmount();
        this.date = donation.getDonationDate();
    }

    public DonationResult(ResultSet rs) throws SQLException {
        super(rs);
        this.setId(rs.getInt(1));
        this.docNr = rs.getString(2);
        this.lastName = rs.getString(3);
        this.firstName = rs.getString(4);
        this.group = rs.getString(5);
        this.type = rs.getString(6);
        this.congregation = rs.getString(7);
        this.amount = rs.getBigDecimal(8);
        this.date = rs.getDate(9);
    }

    public static List<DonationResult> fromResultSet(ResultSet rs) throws SQLException {
        ArrayList<DonationResult> list = new ArrayList<DonationResult>();
        while (rs.next()) {
            list.add(new DonationResult(rs));
        }
        return list;
    }

    public static String getFields() {
        return "id, doc_nr, lastname, firstname, group_name, donation_type_name, congregation_name, amount, donation_date";
    }
}

