/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.report;

import eelk.koguja.report.DlgReportPreview;
import eelk.koguja.report.MultiRSDataSource;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class ReportManager {
    public static final String PRM_TITLE = "TITLE";
    public static final String PRM_BUNDLE = "REPORT_RESOURCE_BUNDLE";
    public static final Logger logger = Logger.getLogger(ReportManager.class);

    public static void runReport(Shell parent, String path, Map<String, Object> prm, JRDataSource dataSource) {
        if (dataSource instanceof MultiRSDataSource && ((MultiRSDataSource)dataSource).data.isEmpty()) {
            MessageBox dialog = new MessageBox(parent);
            dialog.setText(Resources.getString("report.empty.title"));
            dialog.setMessage(Resources.getString("report.empty.message"));
            dialog.open();
            return;
        }
        if (prm == null) {
            prm = new HashMap<String, Object>();
        }
        prm.put(PRM_BUNDLE, Resources.getBundle());
        URL url = Util.getResource(path);
        try {
            String title = Util.c((String)prm.get(PRM_TITLE));
            JasperPrint p = JasperFillManager.fillReport(url.openStream(), prm, dataSource);
            DlgReportPreview dlgPreview = new DlgReportPreview(parent, title, p);
            dlgPreview.open();
        }
        catch (JRException e) {
            SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Report.Preview"), new Object[0]);
        }
        catch (IOException x) {
            SwtExceptionHandler.instance().Ex(x, logger, Resources.getErrString("Report.Preview"), new Object[0]);
        }
    }
}

