/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.preference;

import eelk.koguja.preference.IPreference;
import eelk.koguja.preference.IPreferenceStore;
import eelk.koguja.preference.PreferenceStore;
import java.io.File;
import java.io.IOException;

public class Preferences
implements IPreference {
    private static final Preferences mPrefs = new Preferences();
    private PreferenceStore store;

    private Preferences() {
    }

    public static IPreferenceStore getStore() {
        return mPrefs.mGetStore();
    }

    public static void save() {
        mPrefs.mSave();
    }

    @Override
    public IPreferenceStore mGetStore() {
        if (this.store == null) {
            String fileName = System.getProperty("user.home") + File.separator + ".koguja" + File.separator + "preferences";
            this.store = new PreferenceStore(fileName);
            File file = new File(fileName);
            try {
                if (file.exists()) {
                    this.store.load();
                } else {
                    File parentDir = file.getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    file.createNewFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.store;
    }

    @Override
    public void mSave() {
        if (this.store == null) {
            return;
        }
        try {
            this.store.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

