/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.preference;

import eelk.koguja.model.DomConnection;
import eelk.koguja.preference.IConnection;
import eelk.koguja.preference.IPreferenceStore;
import eelk.koguja.preference.Preferences;
import java.util.Properties;

public class MConnection
implements IConnection {
    private static MConnection instance;
    private static final IPreferenceStore store;

    private MConnection() {
    }

    public static IConnection instance() {
        if (instance == null) {
            instance = new MConnection();
        }
        return instance;
    }

    @Override
    public void init(DomConnection connection) {
        Properties p = System.getProperties();
        if (p.getProperty("db.driver") != null && !p.getProperty("db.driver").isEmpty()) {
            connection.setDriver(p.getProperty("db.driver"));
        }
        if (p.getProperty("db.host") != null && !p.getProperty("db.host").isEmpty()) {
            connection.setHost(p.getProperty("db.host"));
        }
        if (p.getProperty("db.port") != null && !p.getProperty("db.port").isEmpty()) {
            connection.setPort(p.getProperty("db.port"));
        }
        if (p.getProperty("db.name") != null && !p.getProperty("db.name").isEmpty()) {
            connection.setDatabaseName(p.getProperty("db.name"));
        }
        if (p.getProperty("db.ssl") != null && !p.getProperty("db.ssl").isEmpty()) {
            connection.setHasSsl(p.getProperty("db.ssl").contains("true"));
        }
    }

    @Override
    public void load(DomConnection connection) {
        if (store.contains("db.driver") && store.getString("db.driver").length() > 0) {
            connection.setDriver(store.getString("db.driver"));
        }
        if (store.contains("db.host") && store.getString("db.host").length() > 0) {
            connection.setHost(store.getString("db.host"));
        }
        if (store.contains("db.port") && store.getString("db.port").length() > 0) {
            connection.setPort(store.getString("db.port"));
        }
        if (store.contains("db.name") && store.getString("db.name").length() > 0) {
            connection.setDatabaseName(store.getString("db.name"));
        }
        if (store.contains("db.ssl") && store.getString("db.ssl").length() > 0) {
            connection.setHasSsl(store.getString("db.ssl").contains("true"));
        }
    }

    @Override
    public void save(DomConnection connection) {
        if (!connection.getDriver().isEmpty()) {
            store.setValue("db.driver", connection.getDriver());
        }
        if (!connection.getHost().isEmpty()) {
            store.setValue("db.host", connection.getHost());
        }
        if (!connection.getPort().isEmpty()) {
            store.setValue("db.port", connection.getPort());
        }
        if (!connection.getDatabaseName().isEmpty()) {
            store.setValue("db.name", connection.getDatabaseName());
        }
        store.setValue("db.ssl", connection.getHasSsl() != false ? "true" : "false");
    }

    static {
        store = Preferences.getStore();
    }
}

