/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.util.Resources;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

public class DomPersonEventHistory
extends BusinessObject {
    public static final int GROUP_EVENT = 1;
    public static final int CONGREGATION_EVENT = 2;
    public static final int RELATIONSHIP_EVENT = 3;
    public static final int INITALIZE = 1;
    public static final int TERMINATE = 2;
    private int eventType;
    private int timeType;
    private Date eventDate;
    private String targetName;

    public DomPersonEventHistory() {
    }

    public DomPersonEventHistory(ResultSet rs) throws SQLException {
        super(rs);
        this.setEventType(rs.getInt("event_type"));
        this.setTimeType(rs.getInt("time_type"));
        this.setEventDate(rs.getDate("event_date"));
        this.setTargetName(rs.getString("target_name"));
    }

    public DomPersonEventHistory(ResultSet rs, Set<String> cols) throws SQLException {
        super(rs, cols);
        if (cols.contains("event_type")) {
            this.setEventType(rs.getInt("event_type"));
        }
        if (cols.contains("time_type")) {
            this.setTimeType(rs.getInt("time_type"));
        }
        if (cols.contains("event_date")) {
            this.setEventDate(rs.getDate("event_date"));
        }
        if (cols.contains("target_name")) {
            this.setTargetName(rs.getString("target_name"));
        }
    }

    public static String nameOfEvent(Integer type) {
        if (type == null) {
            return "<unknown>";
        }
        switch (type) {
            case 1: {
                return Resources.getString("Event.EventType.Group");
            }
            case 2: {
                return Resources.getString("Event.EventType.Congregation");
            }
            case 3: {
                return Resources.getString("Event.EventType.Relationship");
            }
        }
        return "<unknown>";
    }

    public static String nameOfTime(Integer timeType, Integer eventType, String targetName) {
        String s = "<unknown>";
        if (timeType == null || eventType == null) {
            return "<unknown>";
        }
        String name = " " + targetName;
        switch (eventType) {
            case 1: {
                if (timeType == 1) {
                    return Resources.getString("Event.JoinGroup") + name;
                }
                if (timeType != 2) break;
                return Resources.getString("Event.LeaveGroup") + name;
            }
            case 2: {
                if (timeType == 1) {
                    return Resources.getString("Event.JoinCongregation") + name;
                }
                if (timeType != 2) break;
                return Resources.getString("Event.LeaveCongregation") + name;
            }
            case 3: {
                if (timeType == 1) {
                    return Resources.getString("Event.JoinRelationship") + name;
                }
                if (timeType != 2) break;
                return Resources.getString("Event.LeaveRelationship") + name;
            }
        }
        return "<unknown>";
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int eventType) {
        this.eventType = eventType;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public int getTimeType() {
        return this.timeType;
    }

    public void setTimeType(int timeType) {
        this.timeType = timeType;
    }
}

