/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.model.DomAddress;
import eelk.koguja.util.Util;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

public class DomPersonAddress
extends BusinessObject {
    public static final String PERSON_ID = "person_id";
    public static final String ADDRESS_ID = "address_id";
    public static final String VALID_FROM = "valid_from";
    public static final String VALID_TO = "valid_to";
    private Integer personId;
    private DomAddress address;
    private Date validFrom;
    private Date validTo;

    public DomPersonAddress(Integer personId) {
        this.setPersonId(personId);
    }

    public DomPersonAddress(Integer personId, DomAddress address) {
        this(personId);
        this.setAddress(address);
    }

    public DomPersonAddress(ResultSet rs) throws SQLException {
        super(rs);
        this.setAddress(new DomAddress(rs));
        this.setAddressId(rs.getObject(ADDRESS_ID) == null ? null : Integer.valueOf(rs.getInt(ADDRESS_ID)));
        this.setPersonId(rs.getObject(PERSON_ID) == null ? null : Integer.valueOf(rs.getInt(PERSON_ID)));
        this.setValidFrom(rs.getDate(VALID_FROM));
        this.setValidTo(rs.getDate(VALID_TO));
    }

    public DomPersonAddress(ResultSet rs, Set<String> cols) throws SQLException {
        super(rs, cols);
        if (cols.contains(VALID_FROM)) {
            this.setValidFrom(rs.getDate(VALID_FROM));
        }
        if (cols.contains(VALID_TO)) {
            this.setValidTo(rs.getDate(VALID_TO));
        }
        this.setAddress(new DomAddress(rs, cols));
        if (cols.contains(ADDRESS_ID)) {
            this.setAddressId(rs.getObject(ADDRESS_ID) == null ? null : Integer.valueOf(rs.getInt(ADDRESS_ID)));
        } else {
            this.setAddressId(null);
        }
        if (cols.contains(PERSON_ID)) {
            this.setPersonId(rs.getObject(PERSON_ID) == null ? null : Integer.valueOf(rs.getInt(PERSON_ID)));
        }
        if (cols.contains(VALID_FROM)) {
            this.setValidFrom(rs.getDate(VALID_FROM));
        }
        if (cols.contains(VALID_TO)) {
            this.setValidTo(rs.getDate(VALID_TO));
        }
    }

    public DomPersonAddress(DomPersonAddress personAddress) {
        super(personAddress);
        if (personAddress.getValidFrom() != null) {
            this.setValidFrom((Date)personAddress.getValidFrom().clone());
        } else {
            this.setValidFrom(null);
        }
        if (personAddress.getValidTo() != null) {
            this.setValidTo((Date)personAddress.getValidTo().clone());
        } else {
            this.setValidTo(null);
        }
        if (personAddress.getAddress() != null) {
            this.setAddress(new DomAddress(personAddress.getAddress()));
        } else {
            this.setAddress(null);
        }
        if (personAddress.getAddressId() != null) {
            this.setAddressId(personAddress.getAddressId());
        } else {
            this.setAddressId(null);
        }
        if (personAddress.getPersonId() != null) {
            this.setPersonId(personAddress.getPersonId());
        } else {
            this.setPersonId(null);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DomPersonAddress)) {
            return false;
        }
        DomPersonAddress personAddress = (DomPersonAddress)o;
        return super.equals(o) && Util.equals(this.getValidFrom(), personAddress.getValidFrom()) && Util.equals(this.getValidTo(), personAddress.getValidTo()) && Util.equals(this.getAddress(), personAddress.getAddress()) && Util.equals(this.getAddressId(), personAddress.getAddressId()) && Util.equals(this.getPersonId(), personAddress.getPersonId());
    }

    public String toString() {
        return (this.getAddress() == null ? "" : this.getAddress().toString()) + " [ " + (this.getValidFrom() == null ? "..." : Util.dateToStr(this.getValidFrom())) + " ] - [ " + (this.getValidTo() == null ? "..." : Util.dateToStr(this.getValidTo())) + " ]";
    }

    public boolean hasEqualValidityPeriod(DomPersonAddress address) {
        if (address == null) {
            return false;
        }
        return Util.compare(this.getValidFrom(), address.getValidFrom()) == 0 && Util.compare(this.getValidTo(), address.getValidTo()) == 0;
    }

    public Integer getAddressId() {
        return this.address == null ? null : Integer.valueOf(this.address.getId());
    }

    public void setAddressId(Integer value) {
        if (value == null) {
            this.address = null;
            return;
        }
        if (this.address == null) {
            this.address = new DomAddress();
        }
        this.address.setId(value);
    }

    public DomAddress getAddress() {
        return this.address;
    }

    public void setAddress(DomAddress address) {
        this.address = address;
    }

    public Integer getPersonId() {
        return this.personId;
    }

    public void setPersonId(Integer personId) {
        this.personId = personId;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public void setValidTo(Date validTo) {
        this.validTo = validTo;
    }
}

