/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.model.DomPerson;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Set;

public class DomParticipant
extends BusinessObject {
    private Integer roleId;
    private DomPerson person;

    public DomParticipant() {
    }

    public DomParticipant(ResultSet rs) throws SQLException {
        super(rs);
        if (rs.getObject("person_id") == null) {
            this.person = null;
        } else {
            this.person = new DomPerson();
            this.person.setId(rs.getInt("person_id"));
            this.person.setFirstName(rs.getString("person_firstname"));
            this.person.setLastName(rs.getString("person_lastname"));
            this.person.setDeathDate(rs.getDate("deathdate"));
        }
        this.setRoleId(rs.getObject("role_id") == null ? null : Integer.valueOf(rs.getInt("role_id")));
    }

    public DomParticipant(ResultSet rs, Set<String> cols) throws SQLException {
        super(rs, cols);
        if (cols.contains("person_id")) {
            if (rs.getObject("person_id") == null) {
                this.person = null;
            } else {
                this.person = new DomPerson();
                this.person.setId(rs.getInt("person_id"));
                this.person.setFirstName(rs.getString("person_firstname"));
                this.person.setLastName(rs.getString("person_lastname"));
                if (cols.contains("person_deathdate")) {
                    this.person.setDeathDate(rs.getDate("person_deathdate"));
                }
            }
        }
        if (cols.contains("role_id")) {
            this.setRoleId(rs.getObject("role_id") == null ? null : Integer.valueOf(rs.getInt("role_id")));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DomParticipant)) {
            return false;
        }
        DomParticipant part = (DomParticipant)o;
        return part.getPersonId().equals(this.getPersonId());
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + this.getPersonId();
        return hash;
    }

    public Object clone() {
        DomParticipant result = new DomParticipant();
        result.setId(this.getId());
        result.setPerson(this.getPerson());
        result.setRoleId(this.getRoleId());
        return result;
    }

    public boolean hasEqualFields(DomParticipant part) {
        return (this.getPersonId() != null && this.getPersonId().equals(part.getPersonId()) || Objects.equals(this.getPersonId(), part.getPersonId())) && (this.getRoleId() != null && this.getRoleId().equals(part.getRoleId()) || this.getRoleId() == part.getRoleId());
    }

    public Integer getPersonId() {
        return this.person == null ? null : Integer.valueOf(this.person.getId());
    }

    public void setPersonId(Integer personId) {
        if (personId == null) {
            this.person = null;
            return;
        }
        if (this.person == null) {
            this.person = new DomPerson();
        }
        if (this.person.getId() != personId.intValue()) {
            this.person.setId(personId);
        }
    }

    public DomPerson getPerson() {
        return this.person;
    }

    public void setPerson(DomPerson person) {
        this.person = person;
    }

    public Integer getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Integer roleId) {
        this.roleId = roleId;
    }
}

