/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.util.Resources;
import java.util.ArrayList;
import java.util.List;

public class DomEventState
extends BusinessObject {
    private String name;

    private DomEventState(int type, int id) {
        this.setId(id);
        this.name = DomEventState.nameOf(type, id);
    }

    public DomEventState() {
    }

    public static List<DomEventState> listAll(int type) {
        ArrayList<DomEventState> allStates = new ArrayList<DomEventState>();
        allStates.add(new DomEventState(type, 0));
        allStates.add(new DomEventState(type, 1));
        allStates.add(new DomEventState(type, 2));
        allStates.add(new DomEventState(type, 3));
        return allStates;
    }

    public static String nameOf(int type, Integer stateId) {
        if (stateId == null) {
            return "<unknown>";
        }
        String suffix = "";
        switch (type) {
            case 0: {
                suffix = ".Baptism";
                break;
            }
            case 1: {
                suffix = ".Confirmation";
                break;
            }
            case 2: {
                suffix = ".Funeral";
                break;
            }
            case 3: {
                suffix = ".Wedding";
            }
        }
        switch (stateId) {
            case 0: {
                return Resources.getString("Event.State.Registered");
            }
            case 1: {
                return Resources.getString("Event.State.Ready");
            }
            case 2: {
                return Resources.getString("Event.State.Completed" + suffix);
            }
            case 3: {
                return Resources.getString("Event.State.Cancelled");
            }
        }
        return "<unknown>";
    }

    public static String nameOf(Integer stateId) {
        if (stateId == null) {
            return "<unknown>";
        }
        switch (stateId) {
            case 0: {
                return Resources.getString("Event.State.Registered");
            }
            case 1: {
                return Resources.getString("Event.State.Ready");
            }
            case 2: {
                return Resources.getString("Event.State.Completed");
            }
            case 3: {
                return Resources.getString("Event.State.Cancelled");
            }
        }
        return "<unknown>";
    }

    public String toString() {
        return this.name;
    }
}

