/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.util.Util;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Set;

public abstract class DomEvent
extends BusinessObject {
    public static final int REGISTERED = 0;
    public static final int READY = 1;
    public static final int COMPLETED = 2;
    public static final int CANCELLED = 3;
    public static final int BAPTISM = 0;
    public static final int CONFIRMATION = 1;
    public static final int FUNERAL = 2;
    public static final int WEDDING = 3;
    public static final int DONATION = 4;
    public static final int PERSON = 5;
    public String location;
    private Integer congregationId;
    private String docNr;
    private String congregationName;
    private Date applicationDate;
    private Integer state;
    private Date eventDate;
    private Date eventFuzzyDate;
    private Time eventStart;
    private Time eventEnd;
    private String scripturalPassage;
    private String legitimation;
    private Integer offciantId;
    private Integer locationId;
    private String comment;
    private String book;
    private String page;

    public DomEvent() {
    }

    public DomEvent(ResultSet rs) throws SQLException {
        super(rs);
        this.setCongregationId(rs.getObject("congregation_id") == null ? null : Integer.valueOf(rs.getInt("congregation_id")));
        this.setCongregationName(rs.getString("congregation_name"));
        this.setDocNr(rs.getString("doc_nr"));
        this.setApplicationDate(rs.getDate("application_date"));
        this.setState(rs.getObject("state") == null ? null : Integer.valueOf(rs.getInt("state")));
        this.setEventDate(rs.getDate("event_date"));
        this.setEventFuzzyDate(rs.getDate("event_date_fuzzy_end"));
        this.setEventStart(rs.getTime("event_start"));
        this.setEventEnd(rs.getTime("event_end"));
        this.setScripturalPassage(Util.c(rs.getString("scriptural_passage")));
        this.setLegitimation(Util.c(rs.getString("legitimation")));
        this.setOffciantId(rs.getObject("officiant_id") == null ? null : Integer.valueOf(rs.getInt("officiant_id")));
        this.setLocationId(rs.getObject("location_id") == null ? null : Integer.valueOf(rs.getInt("location_id")));
        this.setComment(Util.c(rs.getString("comment")));
        this.setBook(Util.c(rs.getString("book")));
        this.setPage(Util.c(rs.getString("page")));
    }

    public DomEvent(ResultSet rs, Set<String> cols) throws SQLException {
        super(rs, cols);
        if (cols.contains("congregation_id")) {
            this.setCongregationId(rs.getObject("congregation_id") == null ? null : Integer.valueOf(rs.getInt("congregation_id")));
        }
        if (cols.contains("congregation_name")) {
            this.setCongregationName(rs.getString("congregation_name"));
        }
        if (cols.contains("doc_nr")) {
            this.setDocNr(rs.getString("doc_nr"));
        }
        if (cols.contains("application_date")) {
            this.setApplicationDate(rs.getDate("application_date"));
        }
        if (cols.contains("state")) {
            this.setState(rs.getObject("state") == null ? null : Integer.valueOf(rs.getInt("state")));
        }
        if (cols.contains("event_date")) {
            this.setEventDate(rs.getDate("event_date"));
        }
        if (cols.contains("event_date_fuzzy_end")) {
            this.setEventFuzzyDate(rs.getDate("event_date_fuzzy_end"));
        }
        if (cols.contains("event_start")) {
            this.setEventStart(rs.getTime("event_start"));
        }
        if (cols.contains("event_end")) {
            this.setEventEnd(rs.getTime("event_end"));
        }
        if (cols.contains("scriptural_passage")) {
            this.setScripturalPassage(rs.getString("scriptural_passage"));
        }
        if (cols.contains("legitimation")) {
            this.setLegitimation(rs.getString("legitimation"));
        }
        if (cols.contains("officiant_id")) {
            this.setOffciantId(rs.getObject("officiant_id") == null ? null : Integer.valueOf(rs.getInt("officiant_id")));
        }
        if (cols.contains("location_id")) {
            this.setLocationId(rs.getObject("location_id") == null ? null : Integer.valueOf(rs.getInt("location_id")));
        }
        if (cols.contains("comment")) {
            this.setComment(rs.getString("comment"));
        }
        if (cols.contains("book")) {
            this.setBook(rs.getString("book"));
        }
        if (cols.contains("page")) {
            this.setPage(rs.getString("page"));
        }
    }

    public DomEvent(DomEvent event) {
        if (event == null) {
            return;
        }
        this.setId(event.getId());
        this.congregationId = event.congregationId;
        this.docNr = event.docNr;
        this.congregationName = event.congregationName;
        this.applicationDate = event.applicationDate;
        this.state = event.state;
        this.eventDate = event.eventDate;
        this.eventFuzzyDate = event.eventFuzzyDate;
        this.eventStart = event.eventStart;
        this.eventEnd = event.eventEnd;
        this.scripturalPassage = event.scripturalPassage;
        this.legitimation = event.legitimation;
        this.offciantId = event.offciantId;
        this.locationId = event.locationId;
        this.location = event.location;
        this.comment = event.comment;
        this.book = event.book;
        this.page = event.page;
    }

    public boolean hasEqualFields(DomEvent event) {
        return this.equals(event) && Util.compare(this.congregationId, event.congregationId) == 0 && Util.compare(this.docNr, event.docNr) == 0 && Util.compare(this.applicationDate, event.applicationDate) == 0 && Util.compare(this.state, event.state) == 0 && Util.compare(this.eventDate, event.eventDate) == 0 && Util.compare(this.eventFuzzyDate, event.eventFuzzyDate) == 0 && Util.compare(this.eventStart, event.eventStart) == 0 && Util.compare(this.eventEnd, event.eventEnd) == 0 && Util.compare(this.scripturalPassage, event.scripturalPassage) == 0 && Util.compare(this.legitimation, event.legitimation) == 0 && Util.compare(this.offciantId, event.offciantId) == 0 && Util.compare(this.locationId, event.locationId) == 0 && Util.compare(this.comment, event.comment) == 0 && Util.compare(this.book, event.book) == 0 && Util.compare(this.page, event.page) == 0;
    }

    public String getDocNr() {
        return this.docNr;
    }

    public void setDocNr(String dn) {
        this.docNr = dn;
    }

    public Date getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = applicationDate;
    }

    public String getBook() {
        return this.book;
    }

    public void setBook(String book) {
        this.book = book;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Integer getCongregationId() {
        return this.congregationId;
    }

    public void setCongregationId(Integer congregationId) {
        this.congregationId = congregationId;
    }

    public String getCongregationName() {
        return this.congregationName;
    }

    public void setCongregationName(String congregationName) {
        this.congregationName = congregationName;
    }

    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public Date getEventFuzzyDate() {
        return this.eventFuzzyDate;
    }

    public void setEventFuzzyDate(Date eventDate) {
        this.eventFuzzyDate = eventDate;
    }

    public Time getEventEnd() {
        return this.eventEnd;
    }

    public void setEventEnd(Time eventEnd) {
        this.eventEnd = eventEnd;
    }

    public Time getEventStart() {
        return this.eventStart;
    }

    public void setEventStart(Time eventStart) {
        this.eventStart = eventStart;
    }

    public String getLegitimation() {
        return this.legitimation;
    }

    public void setLegitimation(String legitimation) {
        this.legitimation = legitimation;
    }

    public Integer getLocationId() {
        return this.locationId;
    }

    public void setLocationId(Integer locationId) {
        this.locationId = locationId;
    }

    public Integer getOffciantId() {
        return this.offciantId;
    }

    public void setOffciantId(Integer offciantId) {
        this.offciantId = offciantId;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getScripturalPassage() {
        return this.scripturalPassage;
    }

    public void setScripturalPassage(String scripturalPassage) {
        this.scripturalPassage = scripturalPassage;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
}

