/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.model.DomDonationWithTypeName;
import eelk.koguja.util.Util;
import java.math.BigDecimal;
import java.util.Calendar;

public class DomDonationsSum
extends DomDonationWithTypeName {
    private final Calendar date = Calendar.getInstance();
    private BigDecimal amount;
    private final String typeName;
    private int sumOf;

    public DomDonationsSum(DomDonationWithTypeName donation) {
        this.date.setTime(donation.getDonationDate());
        this.amount = donation.getAmount();
        this.setDonationObject(donation.getDonationObject());
        this.typeName = donation.getTypeName();
        this.sumOf = 1;
    }

    public void add(DomDonationWithTypeName donation) {
        if (donation != null) {
            if (this.amount == null) {
                this.amount = new BigDecimal("0");
            }
            this.amount = this.amount.add(donation.getAmount() == null ? new BigDecimal("0") : donation.getAmount());
            ++this.sumOf;
        }
    }

    public int getYear() {
        return this.date.get(1);
    }

    public int getSumOf() {
        return this.sumOf;
    }

    public boolean isSum() {
        return this.sumOf > 1;
    }

    public String getDate() {
        return this.isSum() ? this.getYear() + "" : Util.dateToStr(this.date.getTime());
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public String getTypeName() {
        return this.isSum() ? "" : this.typeName;
    }
}

