/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.model.BusinessObject;
import eelk.koguja.util.PersonCode;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Set;

public class DomDonation
extends BusinessObject {
    public static final int P_DONATOR_PERSON = 0;
    public static final int P_DONATOR_GROUP = 1;
    public static final int P_DONATOR_ANON = 2;
    public static final int PAYMENT_METHOD_BANK = 0;
    public static final int PAYMENT_METHOD_CASH = 1;
    private String docNr;
    private Integer typeId;
    private Boolean isMbsDonation;
    private Integer intendedUseId;
    private Integer donationFrom;
    private Integer personId;
    private String personFirstName;
    private String personLastName;
    private Date personBirthDate;
    private String personCode;
    private Integer groupId;
    private String groupName;
    private Integer congregationId;
    private Date donationDate;
    private String donationObject;
    private BigDecimal amount;
    private Boolean isApproxAmount;
    private Boolean isTaxReturned;
    private Integer paymentMethod;
    private String comment;
    private String book;
    private String page;
    private String modifiedComment;

    public DomDonation() {
    }

    public DomDonation(ResultSet rs) throws SQLException {
        super(rs);
        this.setDocNr(rs.getString("doc_nr"));
        this.setTypeId(rs.getObject("type_id") == null ? null : Integer.valueOf(rs.getInt("type_id")));
        this.setIntendedUseId(rs.getObject("intended_use_id") == null ? null : Integer.valueOf(rs.getInt("intended_use_id")));
        this.setDonationFrom(rs.getObject("donation_from") == null ? null : Integer.valueOf(rs.getInt("donation_from")));
        this.setPersonId(rs.getObject("person_id") == null ? null : Integer.valueOf(rs.getInt("person_id")));
        this.setPersonFirstName(rs.getString("person_firstname"));
        this.setPersonLastName(rs.getString("person_lastname"));
        this.setPersonBirthDate(rs.getDate("person_birthdate"));
        this.setPersonCode(rs.getString("person_code"));
        this.setGroupId(rs.getObject("group_id") == null ? null : Integer.valueOf(rs.getInt("group_id")));
        this.setGroupName(rs.getString("group_name"));
        this.setCongregationId(rs.getObject("congregation_id") == null ? null : Integer.valueOf(rs.getInt("congregation_id")));
        this.setDonationDate(rs.getDate("donation_date"));
        this.setDonationObject(rs.getString("donation_object"));
        this.setAmount(rs.getObject("amount") == null ? null : rs.getBigDecimal("amount"));
        this.setIsApproxAmount(rs.getObject("is_approx_amount") == null ? null : Boolean.valueOf(rs.getBoolean("is_approx_amount")));
        this.setIsTaxReturned(rs.getObject("is_tax_returned") == null ? null : Boolean.valueOf(rs.getBoolean("is_tax_returned")));
        this.setPaymentMethod(rs.getObject("payment_method") == null ? null : Integer.valueOf(rs.getInt("payment_method")));
        this.setComment(rs.getString("comment"));
        this.setBook(rs.getString("book"));
        this.setPage(rs.getString("page"));
        this.setModifiedComment(rs.getString("modified_comment"));
    }

    public DomDonation(ResultSet rs, Set<String> cols) throws SQLException {
        super(rs, cols);
        if (cols.contains("doc_nr")) {
            this.setDocNr(rs.getString("doc_nr"));
        }
        if (cols.contains("type_id")) {
            this.setTypeId(rs.getObject("type_id") == null ? null : Integer.valueOf(rs.getInt("type_id")));
        }
        if (cols.contains("intended_use_id")) {
            this.setIntendedUseId(rs.getObject("intended_use_id") == null ? null : Integer.valueOf(rs.getInt("intended_use_id")));
        }
        if (cols.contains("donation_from")) {
            this.setDonationFrom(rs.getObject("donation_from") == null ? null : Integer.valueOf(rs.getInt("donation_from")));
        }
        if (cols.contains("person_id")) {
            this.setPersonId(rs.getObject("person_id") == null ? null : Integer.valueOf(rs.getInt("person_id")));
        }
        if (cols.contains("person_firstname")) {
            this.setPersonFirstName(rs.getString("person_firstname"));
        }
        if (cols.contains("person_lastname")) {
            this.setPersonLastName(rs.getString("person_lastname"));
        }
        if (cols.contains("person_birthdate")) {
            this.setPersonBirthDate(rs.getDate("person_birthdate"));
        }
        if (cols.contains("person_code")) {
            this.setPersonCode(rs.getString("person_code"));
        }
        if (cols.contains("group_id")) {
            this.setGroupId(rs.getObject("group_id") == null ? null : Integer.valueOf(rs.getInt("group_id")));
        }
        if (cols.contains("group_name")) {
            this.setGroupName(rs.getString("group_name"));
        }
        if (cols.contains("congregation_id")) {
            this.setCongregationId(rs.getObject("congregation_id") == null ? null : Integer.valueOf(rs.getInt("congregation_id")));
        }
        if (cols.contains("donation_date")) {
            this.setDonationDate(rs.getDate("donation_date"));
        }
        if (cols.contains("donation_object")) {
            this.setDonationObject(rs.getString("donation_object"));
        }
        if (cols.contains("amount")) {
            this.setAmount(rs.getObject("amount") == null ? null : rs.getBigDecimal("amount"));
        }
        if (cols.contains("is_approx_amount")) {
            this.setIsApproxAmount(rs.getObject("is_approx_amount") == null ? null : Boolean.valueOf(rs.getBoolean("is_approx_amount")));
        }
        if (cols.contains("is_tax_returned")) {
            this.setIsTaxReturned(rs.getObject("is_tax_returned") == null ? null : Boolean.valueOf(rs.getBoolean("is_tax_returned")));
        }
        if (cols.contains("payment_method")) {
            this.setPaymentMethod(rs.getObject("payment_method") == null ? null : Integer.valueOf(rs.getInt("payment_method")));
        }
        if (cols.contains("comment")) {
            this.setComment(rs.getString("comment"));
        }
        if (cols.contains("book")) {
            this.setBook(rs.getString("book"));
        }
        if (cols.contains("page")) {
            this.setPage(rs.getString("page"));
        }
        if (cols.contains("modified_comment")) {
            this.setModifiedComment(rs.getString("modified_comment"));
        }
    }

    public String getINF4Line(DecimalFormat decimalFormat) {
        if (this.getDonationFrom() == null || this.getDonationFrom() != 0) {
            return null;
        }
        if (this.isTaxReturned() == null || !this.isTaxReturned().booleanValue()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (this.getPersonFirstName() == null) {
            return null;
        }
        result.append(this.getPersonFirstName());
        result.append(" ");
        if (this.getPersonLastName() == null) {
            return null;
        }
        result.append(this.getPersonLastName());
        result.append(";");
        if (this.getPersonCode() == null || !PersonCode.isCorrect(this.getPersonCode())) {
            return null;
        }
        result.append(this.getPersonCode());
        result.append(";");
        if (this.getAmount() == null) {
            return null;
        }
        result.append(decimalFormat.format(this.getAmount().doubleValue()));
        return result.toString();
    }

    public String getModifiedComment() {
        return this.modifiedComment;
    }

    public void setModifiedComment(String modifiedComment) {
        this.modifiedComment = modifiedComment;
    }

    public String getBook() {
        return this.book;
    }

    public void setBook(String book) {
        this.book = book;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Integer getCongregationId() {
        return this.congregationId;
    }

    public void setCongregationId(Integer congregationId) {
        this.congregationId = congregationId;
    }

    public Date getDonationDate() {
        return this.donationDate;
    }

    public void setDonationDate(Date donationDate) {
        this.donationDate = donationDate;
    }

    public Integer getDonationFrom() {
        return this.donationFrom;
    }

    public void setDonationFrom(Integer donationFrom) {
        this.donationFrom = donationFrom;
    }

    public Integer getIntendedUseId() {
        return this.intendedUseId;
    }

    public void setIntendedUseId(Integer donationIntendedUseId) {
        this.intendedUseId = donationIntendedUseId;
    }

    public String getDonationObject() {
        return this.donationObject;
    }

    public void setDonationObject(String donationObject) {
        this.donationObject = donationObject;
    }

    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(Integer donationTypeId) {
        this.typeId = donationTypeId;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Boolean isApproxAmount() {
        return this.isApproxAmount;
    }

    public void setIsApproxAmount(Boolean isApproxAmount) {
        this.isApproxAmount = isApproxAmount;
    }

    public Boolean isTaxReturned() {
        return this.isTaxReturned;
    }

    public void setIsTaxReturned(Boolean isTaxReturned) {
        this.isTaxReturned = isTaxReturned;
    }

    public Date getPersonBirthDate() {
        return this.personBirthDate;
    }

    public void setPersonBirthDate(Date personBirthDate) {
        this.personBirthDate = personBirthDate;
    }

    public String getPersonCode() {
        return this.personCode;
    }

    public void setPersonCode(String personCode) {
        this.personCode = personCode;
    }

    public String getPersonFirstName() {
        return this.personFirstName;
    }

    public void setPersonFirstName(String personFirstName) {
        this.personFirstName = personFirstName;
    }

    public Integer getPersonId() {
        return this.personId;
    }

    public void setPersonId(Integer personId) {
        this.personId = personId;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public void setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
    }

    public Integer getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(Integer paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public Boolean isMbsDonation() {
        return this.isMbsDonation;
    }

    public void setIsMbsDonation(Boolean isMbsDonation) {
        this.isMbsDonation = isMbsDonation;
    }

    public String getDocNr() {
        return this.docNr;
    }

    public void setDocNr(String docNr) {
        this.docNr = docNr;
    }
}

