/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.util.Util;

public class DomConnection {
    public static final String KEY_DB_DRIVER = "db.driver";
    public static final String KEY_DB_HOST = "db.host";
    public static final String KEY_DB_PORT = "db.port";
    public static final String KEY_DB_NAME = "db.name";
    private String driver = "org.postgresql.Driver";
    private String host = "eelkpg.ml.ee";
    private String port = "54321";
    private String databaseName = "eelkprod";
    private String databaseUser = "";
    private Boolean hasSsl = true;

    public DomConnection() {
    }

    public DomConnection(DomConnection connection) {
        if (connection.getHost() != null) {
            this.setHost(connection.getHost());
        }
        if (connection.getPort() != null) {
            this.setPort(connection.getPort());
        }
        if (connection.getDatabaseName() != null) {
            this.setDatabaseName(connection.getDatabaseName());
        }
        if (connection.getDatabaseUser() != null) {
            this.setDatabaseUser(connection.getDatabaseUser());
        }
        if (connection.getHasSsl().booleanValue()) {
            this.setHasSsl(connection.getHasSsl());
        }
        if (connection.getDriver() != null) {
            this.setDriver(connection.getDriver());
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.driver != null && this.driver.contains("mysql")) {
            buf.append("jdbc:mysql://");
        } else {
            buf.append("jdbc:postgresql://");
        }
        buf.append(this.host);
        buf.append(":").append(this.port);
        buf.append("/").append(this.databaseName).append("?");
        int hasQueryString = 0;
        if (this.databaseUser != null && !this.databaseUser.isEmpty()) {
            buf.append("user=").append(this.databaseUser);
            hasQueryString = 1;
        }
        if (this.hasSsl.booleanValue()) {
            if (hasQueryString > 0) {
                buf.append("&");
            }
            buf.append("ssl=true");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DomConnection)) {
            return false;
        }
        DomConnection address = (DomConnection)o;
        return super.equals(o) && Util.equals(this.getHost(), address.getHost()) && Util.equals(this.getPort(), address.getPort()) && Util.equals(this.getDatabaseName(), address.getDatabaseName()) && Util.equals(this.getDatabaseUser(), address.getDatabaseUser()) && Util.equals(this.getHasSsl(), address.getHasSsl());
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.host != null ? this.host.hashCode() : 0);
        hash = 37 * hash + (this.port != null ? this.port.hashCode() : 0);
        hash = 37 * hash + (this.databaseName != null ? this.databaseName.hashCode() : 0);
        hash = 37 * hash + (this.databaseUser != null ? this.databaseUser.hashCode() : 0);
        hash = 37 * hash + (this.hasSsl != false ? 1 : 0);
        return hash;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public Boolean getHasSsl() {
        return this.hasSsl;
    }

    public void setHasSsl(Boolean hasSsl) {
        this.hasSsl = hasSsl;
    }
}

