/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.model.DomAttribute;
import eelk.koguja.util.Util;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;

public class DomAttributeSearch
extends DomAttribute
implements Comparable<DomAttribute> {
    public static final String P_USED_IN_SEARCH = "used_in_search";
    public static final String P_IS_YES = "is_yes";
    private boolean usedInSearch;
    private boolean isYes;

    public DomAttributeSearch() {
    }

    public DomAttributeSearch(ResultSet rs) throws SQLException {
        super(rs);
        this.setUsedInSearch(rs.getBoolean(P_USED_IN_SEARCH));
        this.setYes(rs.getBoolean(P_IS_YES));
    }

    public DomAttributeSearch(ResultSet rs, Set<String> cols) throws SQLException {
        super(rs, cols);
        if (cols.contains(P_USED_IN_SEARCH)) {
            this.setUsedInSearch(rs.getBoolean(P_USED_IN_SEARCH));
        }
        if (cols.contains(P_IS_YES)) {
            this.setYes(rs.getBoolean(P_IS_YES));
        }
    }

    @Override
    public DomAttributeSearch clone() {
        DomAttributeSearch clone = new DomAttributeSearch();
        clone.setId(this.getId());
        clone.setRank(this.getRank());
        clone.setName(this.getName());
        clone.setModified_by(this.getModified_by());
        clone.setModified_on(this.getModified_on());
        clone.setUsedInSearch(this.isUsedInSearch());
        clone.setYes(this.isYes());
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DomAttributeSearch)) {
            return false;
        }
        DomAttributeSearch m = (DomAttributeSearch)o;
        return m.getName().equals(this.getName()) && m.isUsedInSearch() == this.isUsedInSearch() && m.isYes() == this.isYes();
    }

    public boolean isYes() {
        return this.isYes;
    }

    public void setYes(boolean isYes) {
        this.isYes = isYes;
    }

    public boolean isUsedInSearch() {
        return this.usedInSearch;
    }

    public void setUsedInSearch(boolean usedInSearch) {
        this.usedInSearch = usedInSearch;
        if (!usedInSearch) {
            this.setYes(false);
        }
    }

    public void switchUsedInSearch() {
        if (!this.usedInSearch) {
            this.setUsedInSearch(true);
            this.setYes(true);
        } else if (this.usedInSearch && this.isYes) {
            this.setYes(false);
        } else {
            this.setUsedInSearch(false);
        }
    }

    @Override
    public void setProperty(String property, Object value) {
        if (property == null) {
            return;
        }
        if (property.equals("name")) {
            this.setName((String)value);
        } else if (property.equals(P_USED_IN_SEARCH)) {
            this.switchUsedInSearch();
        } else if (property.equals(P_IS_YES)) {
            this.setYes((Boolean)value);
        }
    }

    @Override
    public Object getProperty(String property) {
        if (property == null) {
            return null;
        }
        if (property.equals("name")) {
            return this.getName();
        }
        if (property.equals(P_USED_IN_SEARCH)) {
            return this.isUsedInSearch();
        }
        if (property.equals(P_IS_YES)) {
            return this.isYes();
        }
        return null;
    }

    @Override
    public int compareTo(DomAttribute attribute) {
        if (Util.compare(this.getRank(), attribute.getRank()) != 0) {
            return Util.compare(this.getRank(), attribute.getRank());
        }
        return Util.compare(this.getName(), attribute.getName());
    }
}

