/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.model;

import eelk.koguja.util.Util;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public abstract class BusinessObject {
    private int id = -1;
    private Date modified_on;
    private String modified_by;

    public BusinessObject() {
    }

    public BusinessObject(ResultSet rs) throws SQLException {
        this(rs, Util.createStringSet("id", "modified_on", "modified_by"));
    }

    public BusinessObject(ResultSet rs, Set<String> cols) throws SQLException {
        if (cols.contains("id")) {
            this.setId(rs.getInt("id"));
        }
        if (cols.contains("modified_on")) {
            this.setModified_on(Util.timeStampToSqlDate(rs.getTimestamp("modified_on")));
        }
        if (cols.contains("modified_by")) {
            this.setModified_by(rs.getString("modified_by"));
        }
    }

    public BusinessObject(BusinessObject b) {
        if (b == null) {
            return;
        }
        this.setId(b.getId());
        this.setModified_on(b.getModified_on());
        this.setModified_by(b.getModified_by());
    }

    public static BusinessObject find(List<? extends BusinessObject> objects, Integer id) {
        if (objects == null || id == null) {
            return null;
        }
        for (BusinessObject businessObject : objects) {
            if (businessObject.getId() != id.intValue()) continue;
            return businessObject;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof BusinessObject)) {
            return false;
        }
        return ((BusinessObject)o).getId() == this.getId();
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + this.getId();
        return hash;
    }

    public void setProperty(String property, Object value) {
    }

    public Object getProperty(String property) {
        return null;
    }

    public Date getModified_on() {
        return this.modified_on;
    }

    public void setModified_on(Date modified_on) {
        this.modified_on = modified_on;
    }

    public String getModified_by() {
        return this.modified_by;
    }

    public void setModified_by(String modified_by) {
        this.modified_by = modified_by;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

