/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.gui;

import java.util.Arrays;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableEx
extends Composite {
    public static final int DEFAULT_COL_MAX_WIDTH = 100;
    int[] colMaxWidths = null;
    private boolean coverAll = true;
    private boolean[] fixedSizeCols = null;
    private final Table table;

    public TableEx(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.table = new Table((Composite)this, style);
    }

    public Table getTable() {
        return this.table;
    }

    public boolean getCoverAll() {
        return this.coverAll;
    }

    public void setCoverAll(boolean value) {
        this.coverAll = value;
    }

    public int[] getColMaxWidths() {
        int[] result = new int[this.table.getColumnCount()];
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = this.colMaxWidths != null && i < this.colMaxWidths.length ? this.colMaxWidths[i] : 100;
        }
        this.colMaxWidths = result;
        return this.colMaxWidths;
    }

    public void setColMaxWidths(int ... widths) {
        if (widths.length != this.table.getColumnCount()) {
            throw new IllegalArgumentException();
        }
        if (this.colMaxWidths == null || this.colMaxWidths.length != widths.length) {
            this.colMaxWidths = new int[widths.length];
        }
        for (int i = widths.length - 1; i >= 0; --i) {
            if (widths[i] <= 0) {
                throw new IllegalArgumentException();
            }
            this.colMaxWidths[i] = widths[i];
        }
    }

    public boolean[] getFixedSizeColumns() {
        if (this.fixedSizeCols == null || this.fixedSizeCols.length != this.table.getColumnCount()) {
            this.fixedSizeCols = new boolean[this.table.getColumnCount()];
            Arrays.fill(this.fixedSizeCols, false);
        }
        return (boolean[])this.fixedSizeCols.clone();
    }

    public void setFixedSizeColumns(boolean ... value) {
        int colCount = this.table.getColumnCount();
        if (value == null || value.length != colCount) {
            throw new IllegalArgumentException();
        }
        if (this.fixedSizeCols == null || this.fixedSizeCols.length != colCount) {
            this.fixedSizeCols = new boolean[colCount];
        }
        for (int i = value.length - 1; i >= 0; --i) {
            this.fixedSizeCols[i] = value[i];
        }
    }

    protected int getFixedSizeColCount() {
        boolean[] a = this.getFixedSizeColumns();
        int result = 0;
        for (boolean b : a) {
            if (!b) continue;
            ++result;
        }
        return result;
    }

    public boolean getHeaderVisible() {
        return this.table.getHeaderVisible();
    }

    public void setHeaderVisible(boolean value) {
        this.table.setHeaderVisible(value);
    }

    public boolean getLinesVisible() {
        return this.table.getLinesVisible();
    }

    public void setLinesVisible(boolean value) {
        this.table.setLinesVisible(value);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.updateColWidths(width - 4);
    }

    protected void updateColWidths(int width) {
        int i;
        if (!this.coverAll) {
            return;
        }
        int[] widths = this.getColMaxWidths();
        int[] newWidths = new int[this.table.getColumnCount()];
        for (int i2 = this.table.getColumnCount() - 1; i2 >= 0; --i2) {
            TableColumn col = this.table.getColumn(i2);
            int MIN_COL_WIDTH = 20;
            newWidths[i2] = Math.max(Math.min(col.getWidth(), widths[i2]), MIN_COL_WIDTH);
            width -= newWidths[i2];
        }
        if (this.getFixedSizeColCount() == this.table.getColumnCount()) {
            return;
        }
        int unfixedCols = this.table.getColumnCount() - this.getFixedSizeColCount();
        int dw = width / unfixedCols;
        boolean[] fixedCols = this.getFixedSizeColumns();
        for (i = this.table.getColumnCount() - 1; i >= 0; --i) {
            if (fixedCols[i]) continue;
            int n = i;
            newWidths[n] = newWidths[n] + dw;
        }
        i = width % unfixedCols;
        while (i > 0) {
            int n = i--;
            newWidths[n] = newWidths[n] + 1;
        }
        for (i = this.table.getColumnCount() - 1; i >= 0; --i) {
            this.table.getColumn(i).setWidth(newWidths[i]);
        }
    }
}

