/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.gui;

import eelk.koguja.gui.FillDateOnFocus;
import eelk.koguja.gui.FuzzyDatePickerCombo;
import eelk.koguja.util.Util;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public final class FuzzyDatePickerSearch
extends FuzzyDatePickerCombo
implements FillDateOnFocus {
    public FuzzyDatePickerSearch(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void dpEvent(Event event) {
        super.dpEvent(event);
        switch (event.type) {
            case 13: {
                if (this.isClosePopupWithSingleMouseClick) break;
            }
            case 8: {
                Date date = this.dp.getDate();
                Date fuzzyDate = this.dp.getFuzzyDate();
                String dateStr = "";
                if (date != null || fuzzyDate != null) {
                    if (date != null) {
                        dateStr = Util.getDateFormat().format(date);
                    }
                    dateStr = dateStr + "-";
                    if (fuzzyDate != null) {
                        dateStr = dateStr + Util.getDateFormat().format(fuzzyDate);
                    }
                }
                this.text.setText(dateStr);
                this.text.selectAll();
                break;
            }
        }
    }

    @Override
    public void setDate(Date date) {
        this.checkWidget();
        if (date != null) {
            this.text.setText(Util.getDateFormat().format(date) + "-");
            this.text.selectAll();
        } else {
            this.text.setText("");
        }
        this.dp.setDate(date);
    }

    @Override
    public void setFuzzyDate(Date date) {
        this.checkWidget();
        if (date != null && this.dp.getDate() != null) {
            this.text.setText(Util.getDateFormat().format(this.dp.getDate()) + "-" + Util.getDateFormat().format(date));
            this.text.selectAll();
        } else if (date != null) {
            this.text.setText("-" + Util.getDateFormat().format(date));
            this.text.selectAll();
        } else {
            this.setDate(this.dp.getDate());
        }
        this.dp.setFuzzyDate(date);
    }

    @Override
    protected void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.dp || focusControl == this.arrow) {
                    return;
                }
                this.hasFocus = false;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(16, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed() || (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) && this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 24: {
                if (!this.popup.isVisible()) {
                    if (this.text.getText().length() == 0) {
                        this.dp.setDate(null);
                        this.dp.setFuzzyDate(null);
                    } else {
                        try {
                            String[] dates = this.text.getText().split("-");
                            if (dates.length == 1 && this.text.getText().indexOf("-") != 0) {
                                this.dp.setDate(sdf.parse(dates[0]));
                                this.dp.setFuzzyDate(null);
                            } else if (this.text.getText().indexOf("-") == 0) {
                                this.dp.setDate(null);
                                this.dp.setFuzzyDate(sdf.parse(dates[1]));
                            } else if (dates.length == 2) {
                                this.dp.setDate(sdf.parse(dates[0]));
                                this.dp.setFuzzyDate(sdf.parse(dates[1]));
                            } else {
                                this.dp.setDate(null);
                                this.dp.setFuzzyDate(null);
                            }
                        }
                        catch (ParseException pe) {
                            this.dp.setDate(null);
                            this.dp.setFuzzyDate(null);
                        }
                    }
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                if (event.button != 1 || this.text.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.text.selectAll();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                if (event.button != 1 || this.text.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                break;
            }
        }
    }
}

