/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.gui;

import eelk.koguja.gui.FuzzyDatePicker;
import eelk.koguja.util.Util;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class FuzzyDatePickerCombo
extends Composite {
    protected static final DateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
    protected Button arrow;
    protected FuzzyDatePicker dp;
    protected boolean hasFocus;
    protected boolean isClosePopupWithSingleMouseClick = false;
    protected Shell popup;
    protected Text text;

    public FuzzyDatePickerCombo(Composite parent, int style) {
        super(parent, FuzzyDatePickerCombo.checkStyle(style));
        style = this.getStyle();
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.text = new Text((Composite)this, textStyle);
        this.popup = new Shell(this.getShell(), 8);
        int pickerStyle = 4;
        if ((style & 0x800000) != 0) {
            pickerStyle |= 0x800000;
        }
        this.dp = new FuzzyDatePicker((Composite)this.popup, pickerStyle);
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrow = new Button((Composite)this, arrowStyle);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (FuzzyDatePickerCombo.this.popup == event.widget) {
                    FuzzyDatePickerCombo.this.popupEvent(event);
                    return;
                }
                if (FuzzyDatePickerCombo.this.text == event.widget) {
                    FuzzyDatePickerCombo.this.textEvent(event);
                    return;
                }
                if (FuzzyDatePickerCombo.this.dp == event.widget) {
                    FuzzyDatePickerCombo.this.dpEvent(event);
                    return;
                }
                if (FuzzyDatePickerCombo.this.arrow == event.widget) {
                    FuzzyDatePickerCombo.this.arrowEvent(event);
                    return;
                }
                if (FuzzyDatePickerCombo.this == event.widget) {
                    FuzzyDatePickerCombo.this.comboEvent(event);
                    return;
                }
            }
        };
        int[] comboEvents = new int[]{12, 10, 11};
        for (int i = 0; i < comboEvents.length; ++i) {
            this.addListener(comboEvents[i], listener);
        }
        int[] popupEvents = new int[]{21, 9, 27};
        for (int i = 0; i < popupEvents.length; ++i) {
            this.popup.addListener(popupEvents[i], listener);
        }
        int[] textEvents = new int[]{1, 2, 24, 3, 4, 31, 15, 16};
        for (int i = 0; i < textEvents.length; ++i) {
            this.text.addListener(textEvents[i], listener);
        }
        int[] dpEvents = new int[]{4, 8, 13, 31, 1, 2, 15, 16};
        for (int i = 0; i < dpEvents.length; ++i) {
            this.dp.addListener(dpEvents[i], listener);
        }
        int[] arrowEvents = new int[]{13, 15, 16};
        for (int i = 0; i < arrowEvents.length; ++i) {
            this.arrow.addListener(arrowEvents[i], listener);
        }
        this.initAccessible();
    }

    public static int checkStyle(int style) {
        int mask = 0x800808;
        return style & mask;
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    private void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.dp || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(16, e);
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
        this.dp.reset();
    }

    private void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.popup.dispose();
                }
                this.popup = null;
                this.text = null;
                this.dp = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout();
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        Point textSize = new Point(122, 13);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(hHint, Math.max(textSize.y, arrowSize.y) + 2 * borderWidth);
        width = Math.max(wHint, textSize.x + arrowSize.x + 2 * borderWidth);
        return new Point(width, height);
    }

    protected void dpEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.text || focusControl == this.arrow) {
                    return;
                }
                this.hasFocus = false;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(16, e);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(14, e);
                break;
            }
            case 13: {
                if (!this.isClosePopupWithSingleMouseClick) {
                    java.util.Date date = this.dp.getDate();
                    java.util.Date fuzzyDate = this.dp.getFuzzyDate();
                    String dateStr = "";
                    if (date != null) {
                        dateStr = Util.getDateFormat().format(date);
                    }
                    String fuzzyDateStr = "";
                    if (fuzzyDate != null) {
                        fuzzyDateStr = "-" + Util.getDateFormat().format(fuzzyDate);
                    }
                    if (date == null) {
                        this.text.setText("");
                    } else {
                        this.text.setText(dateStr + fuzzyDateStr);
                        this.text.selectAll();
                    }
                    this.text.selectAll();
                    Event e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    e.doit = event.doit;
                    this.notifyListeners(13, e);
                    event.doit = e.doit;
                    break;
                }
            }
            case 8: {
                this.dropDown(false);
                java.util.Date date = this.dp.getDate();
                java.util.Date fuzzyDate = this.dp.getFuzzyDate();
                String dateStr = "";
                if (date != null) {
                    dateStr = Util.getDateFormat().format(date);
                }
                String fuzzyDateStr = "";
                if (fuzzyDate != null) {
                    fuzzyDateStr = "-" + Util.getDateFormat().format(fuzzyDate);
                }
                if (date == null) {
                    this.text.setText("");
                } else {
                    this.text.setText(dateStr + fuzzyDateStr);
                    this.text.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 16: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r' || event.character == '\t') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
        }
    }

    protected void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            this.text.setFocus();
            return;
        }
        this.dp.setDate(this.dp.getDate());
        this.dp.setFuzzyDate(this.dp.getFuzzyDate());
        Rectangle listRect = this.dp.getBounds();
        Point point = this.getParent().toDisplay(this.getLocation());
        Point comboSize = this.getSize();
        int width = Math.max(comboSize.x, listRect.width + 2);
        this.popup.setBounds(point.x, point.y + comboSize.y, width, listRect.height + 2);
        this.popup.setVisible(true);
        this.dp.setFocus();
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public java.util.Date getDate() {
        this.checkWidget();
        return Util.dateYear2to4(this.dp.getDate());
    }

    public void setDate(java.util.Date date) {
        this.checkWidget();
        if (date != null) {
            this.text.setText(Util.getDateFormat().format(date));
            this.text.selectAll();
        } else {
            this.text.setText("");
        }
        this.dp.setDate(date);
    }

    public Date getSqlDate() {
        return Util.dateYear2to4(this.getDate());
    }

    public Date getSqlFuzzyDate() {
        return Util.dateYear2to4(this.dp.getFuzzyDate());
    }

    public boolean getEditable() {
        return this.text.getEditable();
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String txt) {
        this.text.setText(txt);
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    private void initAccessible() {
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = FuzzyDatePickerCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = FuzzyDatePickerCombo.this.toControl(new Point(e.x, e.y));
                if (FuzzyDatePickerCombo.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = FuzzyDatePickerCombo.this.getBounds();
                Point pt = FuzzyDatePickerCombo.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = FuzzyDatePickerCombo.this.text.getText();
            }
        });
    }

    private void internalLayout() {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.arrow.computeSize(-1, height);
        this.text.setBounds(0, 0, width - arrowSize.x, height);
        this.arrow.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
        Point size = this.getSize();
        int itemHeight = this.dp.getBounds().height;
        Point listSize = this.dp.computeSize(-1, itemHeight);
        this.dp.setBounds(1, 1, Math.max(size.x - 2, listSize.x), listSize.y);
    }

    public boolean isClosePopupWithSingleMouseClick() {
        return this.isClosePopupWithSingleMouseClick;
    }

    public void setClosePopupWithSingleMouseClick(boolean isClosePopupWithSingleMouseClick) {
        this.isClosePopupWithSingleMouseClick = isClosePopupWithSingleMouseClick;
    }

    protected boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.arrow.isFocusControl() || this.dp.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    private void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.dp.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
            }
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (!all) {
            return;
        }
        Point location = this.text.getLocation();
        this.text.redraw(x - location.x, y - location.y, width, height, all);
        location = this.dp.getLocation();
        this.dp.redraw(x - location.x, y - location.y, width, height, all);
        if (this.arrow != null) {
            location = this.arrow.getLocation();
            this.arrow.redraw(x - location.x, y - location.y, width, height, all);
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.dp != null) {
            this.dp.setBackground(color);
        }
        if (this.arrow != null) {
            this.arrow.setBackground(color);
        }
    }

    public void setFuzzyDate(java.util.Date date) {
        this.checkWidget();
        if (date != null && this.dp.getDate() != null) {
            this.text.setText(Util.getDateFormat().format(this.dp.getDate()) + "-" + Util.getDateFormat().format(date));
            this.text.selectAll();
        } else {
            this.setDate(this.dp.getDate());
        }
        this.dp.setFuzzyDate(date);
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
        this.dp.setFont(font);
        this.internalLayout();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.dp != null) {
            this.dp.setForeground(color);
        }
        if (this.arrow != null) {
            this.arrow.setForeground(color);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.text.setSelection(selection.x, selection.y);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    protected void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.hasFocus = true;
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.dp || focusControl == this.arrow) {
                    return;
                }
                this.hasFocus = false;
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(16, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed() || (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) && this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 24: {
                if (!this.popup.isVisible()) {
                    if (this.text.getText().length() == 0) {
                        this.dp.setDate(null);
                        this.dp.setFuzzyDate(null);
                    } else {
                        try {
                            String[] dates = this.text.getText().split("-");
                            if (dates.length == 1) {
                                this.dp.setDate(sdf.parse(dates[0]));
                                this.dp.setFuzzyDate(null);
                            } else if (dates.length == 2) {
                                this.dp.setDate(sdf.parse(dates[0]));
                                this.dp.setFuzzyDate(sdf.parse(dates[1]));
                            } else {
                                this.dp.setDate(null);
                                this.dp.setFuzzyDate(null);
                            }
                        }
                        catch (ParseException pe) {
                            this.dp.setDate(null);
                            this.dp.setFuzzyDate(null);
                        }
                    }
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                if (event.button != 1 || this.text.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.text.selectAll();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                if (event.button != 1 || this.text.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                break;
            }
        }
    }
}

