/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.gui;

import eelk.koguja.gui.DatePicker;
import eelk.koguja.util.Resources;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class FuzzyDatePicker
extends Composite {
    final Button fuzzyDate;
    private Calendar cal = Calendar.getInstance();
    private final DatePicker dp;
    private Date selectedDate;
    private Date selectedFuzzyDate;
    private final DatePanel datePanel;
    private final DateFormatSymbols dateSymbols = new DateFormatSymbols();
    private final Label monthLabel;
    private int selection = -1;

    public FuzzyDatePicker(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setBackground(Display.getCurrent().getSystemColor(14));
        this.setLayout((Layout)gridLayout);
        Button prevYear = new Button((Composite)this, 0x800000);
        GridData gridData = new GridData(32);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        prevYear.setLayoutData((Object)gridData);
        prevYear.setText("<<");
        prevYear.setSelection(false);
        prevYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyDatePicker.this.cal.roll(1, -1);
                FuzzyDatePicker.this.updateDate();
            }
        });
        Button prevMonth = new Button((Composite)this, 0x800000);
        gridData = new GridData(32);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        prevMonth.setLayoutData((Object)gridData);
        prevMonth.setText("<");
        prevMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyDatePicker.this.cal.roll(2, -1);
                FuzzyDatePicker.this.updateDate();
            }
        });
        this.monthLabel = new Label((Composite)this, 0x1000000);
        gridData = new GridData(770);
        gridData.heightHint = prevYear.computeSize((int)20, (int)20).y;
        gridData.grabExcessHorizontalSpace = true;
        this.monthLabel.setLayoutData((Object)gridData);
        Button nextMonth = new Button((Composite)this, 0x800000);
        gridData = new GridData(128);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        nextMonth.setLayoutData((Object)gridData);
        nextMonth.setText(">");
        nextMonth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyDatePicker.this.cal.roll(2, 1);
                FuzzyDatePicker.this.updateDate();
            }
        });
        Button nextYear = new Button((Composite)this, 0x800000);
        gridData = new GridData(128);
        gridData.widthHint = 20;
        gridData.heightHint = 20;
        nextYear.setLayoutData((Object)gridData);
        nextYear.setText(">>");
        nextYear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyDatePicker.this.cal.roll(1, 1);
                FuzzyDatePicker.this.updateDate();
            }
        });
        this.datePanel = new DatePanel(this, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 5;
        this.datePanel.setLayoutData(gridData);
        this.fuzzyDate = new Button((Composite)this, 32);
        gridData = new GridData(256);
        gridData.horizontalSpan = 5;
        gridData.heightHint = 20;
        this.fuzzyDate.setLayoutData((Object)gridData);
        this.fuzzyDate.setText(Resources.getString("FuzzyDatePicker.FuzzyDate"));
        this.fuzzyDate.setBackground(Display.getCurrent().getSystemColor(1));
        this.fuzzyDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyDatePicker.this.dp.setVisible(((Button)e.widget).getSelection());
                Point tsSize = FuzzyDatePicker.this.computeSize(-1, -1, false);
                Point dpSize = FuzzyDatePicker.this.dp.computeSize(-1, -1, false);
                Rectangle r = FuzzyDatePicker.this.getBounds();
                r.height = ((Button)e.widget).getSelection() ? tsSize.y : tsSize.y;
                FuzzyDatePicker.this.getThis().setSize(r.width, r.height);
                FuzzyDatePicker.this.getThis().setBounds(r);
                Rectangle rParent = FuzzyDatePicker.this.getThis().getParent().getBounds();
                rParent.height = r.height + 2;
                FuzzyDatePicker.this.getThis().getParent().setBounds(rParent);
                Event ev = new Event();
                ev.time = e.time;
                FuzzyDatePicker.this.dp.notifyListeners(13, ev);
                FuzzyDatePicker.this.updateDate();
            }
        });
        this.dp = new DatePicker(this, 32);
        gridData = new GridData(256);
        gridData.horizontalSpan = 5;
        this.dp.setLayoutData(gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (FuzzyDatePicker.this.dp == event.widget) {
                    FuzzyDatePicker.this.dpEvent(event);
                    return;
                }
            }
        };
        int[] dpEvents = new int[]{4, 8, 13, 31, 1, 2, 15, 16};
        for (int i = 0; i < dpEvents.length; ++i) {
            this.dp.addListener(dpEvents[i], listener);
        }
        this.updateDate();
    }

    private void dpEvent(Event event) {
        switch (event.type) {
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(14, e);
                break;
            }
            case 13: {
                this.selectedFuzzyDate = this.dp.getDate();
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 8: {
                this.selectedFuzzyDate = this.dp.getDate();
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                if (this.getDate() != null) {
                    this.notifyListeners(8, e);
                }
                event.doit = e.doit;
                break;
            }
            case 31: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public FuzzyDatePicker getThis() {
        return this;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point pSize = this.datePanel.computeSize(wHint, hHint, changed);
        Point labelSize = this.monthLabel.computeSize(wHint, hHint, changed);
        int x = pSize.x < labelSize.x + 80 ? labelSize.x + 80 : pSize.x;
        int y = pSize.y + 40 + (this.dp != null ? (this.dp.isVisible() ? pSize.y + 30 : 0) : 0);
        return new Point(x, y);
    }

    private void dateSelected(boolean good) {
        if (good) {
            this.selectedDate = this.cal.getTime();
        }
        Event event = new Event();
        event.doit = good;
        this.notifyListeners(13, event);
    }

    private void doubleClick() {
        Event event = new Event();
        event.doit = true;
        this.notifyListeners(8, event);
    }

    private String getCurrentMonthName() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getMonthName(this.cal.get(2)));
        sb.append(", ");
        sb.append(this.cal.get(1));
        return sb.toString();
    }

    public Date getDate() {
        return this.selectedDate;
    }

    public void setDate(Date date) {
        this.selectedDate = date;
        this.cal.setTime(this.selectedDate == null ? new Date() : date);
        this.updateMonthLabel();
        this.redraw();
    }

    public Date getFuzzyDate() {
        return this.fuzzyDate.getSelection() ? this.selectedFuzzyDate : null;
    }

    public void setFuzzyDate(Date date) {
        this.selectedFuzzyDate = date;
        this.dp.setDate(date);
        if (this.fuzzyDate != null && date != null) {
            this.fuzzyDate.setSelection(false);
            this.dp.setVisible(false);
            Point tsSize = this.computeSize(-1, -1, false);
            Point dpSize = this.dp.computeSize(-1, -1, false);
            Rectangle r = this.getBounds();
            this.fuzzyDate.setSelection(true);
            this.dp.setVisible(true);
            r.height = tsSize.y + dpSize.y;
            this.getThis().setSize(r.width, r.height);
            this.getThis().setBounds(r);
            Rectangle rParent = this.getThis().getParent().getBounds();
            rParent.height = r.height + 2;
            this.getThis().getParent().setBounds(rParent);
            this.updateDate();
        } else if (this.fuzzyDate != null) {
            this.fuzzyDate.setSelection(false);
            Point tsSize = this.computeSize(-1, -1, false);
            Rectangle r = this.getBounds();
            r.height = tsSize.y;
            this.getThis().setSize(r.width, r.height);
            this.getThis().setBounds(r);
            Rectangle rParent = this.getThis().getParent().getBounds();
            rParent.height = r.height + 2;
            this.getThis().getParent().setBounds(rParent);
            this.dp.setVisible(false);
            this.updateDate();
        }
    }

    private String getMonthName(int month) {
        return this.dateSymbols.getMonths()[month];
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void reset() {
        this.cal = Calendar.getInstance();
        this.updateDate();
    }

    private void updateDate() {
        this.datePanel.redraw();
        this.updateMonthLabel();
    }

    private void updateMonthLabel() {
        this.monthLabel.setText(this.getCurrentMonthName());
    }

    private class DatePanel
    extends Canvas {
        private final int colSize;
        private final Display display;
        private final int rowSize;
        private final Calendar temp;

        public DatePanel(Composite parent, int style) {
            super(parent, style | 0x40000 | 0x100000);
            this.display = Display.getCurrent();
            this.temp = Calendar.getInstance();
            GC gc = new GC((Drawable)this);
            Point p = gc.stringExtent("Q");
            gc.dispose();
            this.colSize = p.x * 3;
            this.rowSize = (int)((double)p.y * 1.2);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent event) {
                    DatePanel.this.onPaint(event);
                }
            });
            this.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    DatePanel.this.redraw();
                }
            });
            this.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    DatePanel.this.onKeyDown(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    FuzzyDatePicker.this.doubleClick();
                }

                public void mouseDown(MouseEvent e) {
                    DatePanel.this.onMouseDown(e);
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    DatePanel.this.onMouseMove(e);
                }
            });
        }

        private int computeOffset(int day) {
            switch (day) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 2;
                }
                case 4: {
                    return 3;
                }
                case 5: {
                    return 4;
                }
                case 6: {
                    return 5;
                }
                case 7: {
                    return 6;
                }
                case 1: {
                    return 7;
                }
            }
            return -1;
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            return new Point(this.colSize * 7, this.rowSize * 7);
        }

        private void drawTextImage(GC gc, String string, int x, int y, int colSize, int rowSize) {
            gc.fillRectangle(x, y, colSize, rowSize);
            gc.drawString(string, x + (colSize - gc.stringExtent((String)string).x) / 2, y, true);
        }

        private int getDayFromPoint(int x, int y) {
            int result = -1;
            for (int i = 1; i <= 31; ++i) {
                Point p = this.getDayPoint(i);
                Rectangle r = new Rectangle(p.x, p.y, this.colSize, this.rowSize);
                if (!r.contains(x, y)) continue;
                result = i;
                break;
            }
            return result;
        }

        private String getDayName(int day) {
            return FuzzyDatePicker.this.dateSymbols.getShortWeekdays()[day == 7 ? 1 : day + 1];
        }

        private Point getDayPoint(int day) {
            this.syncTime();
            this.temp.set(5, 1);
            int firstDayOffset = this.computeOffset(this.temp.get(7)) - 1;
            this.temp.set(5, day);
            int dayOffset = this.computeOffset(this.temp.get(7));
            int x = (dayOffset - 1) * this.colSize;
            int y = (1 + (firstDayOffset + day - 1) / 7) * this.rowSize;
            return new Point(x, y);
        }

        private int getMaxDay() {
            this.syncTime();
            int day = 28;
            for (int i = 0; i < 10; ++i) {
                this.temp.set(5, day);
                if (this.temp.get(2) != FuzzyDatePicker.this.cal.get(2)) {
                    return day - 1;
                }
                ++day;
            }
            return -1;
        }

        private void onKeyDown(KeyEvent e) {
            if (e.character == '\u001b') {
                FuzzyDatePicker.this.dateSelected(false);
                return;
            }
            if (e.character == ' ' || e.character == '\r') {
                FuzzyDatePicker.this.dateSelected(true);
                return;
            }
            int day = FuzzyDatePicker.this.cal.get(5);
            int month = FuzzyDatePicker.this.cal.get(2);
            int oldDay = day--;
            int oldMonth = month;
            if (e.keyCode == 0x1000003) {
                // empty if block
            }
            if (e.keyCode == 0x1000004) {
                ++day;
            }
            if (e.keyCode == 0x1000001) {
                int n = day = day - 7 < 1 ? oldDay : day - 7;
            }
            if (e.keyCode == 0x1000002) {
                int n = day = day + 7 > this.getMaxDay() ? oldDay : day + 7;
            }
            if (e.keyCode == 0x1000005) {
                --month;
            }
            if (e.keyCode == 0x1000006) {
                ++month;
            }
            FuzzyDatePicker.this.cal.set(2, month);
            FuzzyDatePicker.this.cal.set(5, day);
            if (day != oldDay || month != oldMonth) {
                this.redraw();
                if (month != oldMonth) {
                    FuzzyDatePicker.this.updateMonthLabel();
                }
            }
        }

        private void onMouseDown(MouseEvent e) {
            int day = this.getDayFromPoint(e.x, e.y);
            if (day > 0) {
                FuzzyDatePicker.this.cal.set(5, day);
                FuzzyDatePicker.this.dateSelected(true);
                FuzzyDatePicker.this.updateDate();
            }
        }

        private void onMouseMove(MouseEvent e) {
            FuzzyDatePicker.this.selection = this.getDayFromPoint(e.x, e.y);
            FuzzyDatePicker.this.updateDate();
        }

        private void onPaint(PaintEvent event) {
            Rectangle rect = this.getClientArea();
            GC gc0 = event.gc;
            Image image = new Image((Device)this.display, rect.width, rect.height);
            GC gc = new GC((Drawable)image);
            gc.setBackground(this.display.getSystemColor(25));
            gc.fillRectangle(rect);
            int x = 0;
            int y = 0;
            for (int i = 0; i < 7; ++i) {
                if (i == 6) {
                    gc.setForeground(this.display.getSystemColor(3));
                }
                this.drawTextImage(gc, this.getDayName(1 + i), x + 2, 0, this.colSize, this.rowSize);
                x += this.colSize;
            }
            gc.setForeground(this.display.getSystemColor(2));
            gc.drawLine(0, 0, rect.width, 0);
            gc.drawLine(0, (y += this.rowSize) - 1, rect.width, y - 1);
            this.syncTime();
            int day = 1;
            while (true) {
                this.temp.set(5, day);
                if (this.temp.get(2) != FuzzyDatePicker.this.cal.get(2)) break;
                int dayOffset = this.computeOffset(this.temp.get(7));
                Point p = this.getDayPoint(day);
                if (day == FuzzyDatePicker.this.cal.get(5)) {
                    gc.setForeground(this.display.getSystemColor(27));
                    gc.setBackground(this.display.getSystemColor(26));
                } else if (day == FuzzyDatePicker.this.selection) {
                    gc.setForeground(this.display.getSystemColor(27));
                    gc.setBackground(this.display.getSystemColor(2));
                } else {
                    gc.setBackground(this.display.getSystemColor(25));
                    gc.setForeground(this.display.getSystemColor(dayOffset == 7 ? 3 : 2));
                }
                this.drawTextImage(gc, "" + day, p.x + 2, p.y, this.colSize, this.rowSize);
                ++day;
            }
            gc0.drawImage(image, 0, 0);
            gc.dispose();
            image.dispose();
        }

        private void syncTime() {
            this.temp.setTimeInMillis(FuzzyDatePicker.this.cal.getTimeInMillis());
        }
    }
}

