/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.gui;

import eelk.koguja.Session;
import eelk.koguja.seq.SeqSearch;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class DlgProgressMonitor
extends IconAndMessageDialog
implements IRunnableContext {
    private static final Logger logger = Logger.getLogger(SeqSearch.class);
    private static final String DEFAULT_TASKNAME = JFaceResources.getString("ProgressMonitorDialog.message");
    protected ProgressIndicator progressIndicator;
    protected Label taskLabel;
    protected Label subTaskLabel;
    protected Button cancel;
    protected boolean operationCancelableState = false;
    protected boolean enableCancelButton;
    protected Cursor arrowCursor;
    private final ProgressMonitor progressMonitor = new ProgressMonitor();
    private String task;
    private int nestingDepth;
    private Cursor waitCursor;
    private boolean openOnRun = true;

    public DlgProgressMonitor(Shell parent) {
        super(parent);
        this.setShellStyle(DlgProgressMonitor.getDefaultOrientation() | 0x800 | 0x20 | 0x10000);
        this.setBlockOnOpen(false);
    }

    protected void updateForClearBlocked() {
        this.setMessage(this.task);
        this.imageLabel.setImage(this.getImage());
    }

    protected void updateForSetBlocked(IStatus reason) {
        this.setMessage(reason.getMessage());
        this.imageLabel.setImage(this.getImage());
    }

    private void asyncSetOperationCancelButtonEnabled(final boolean b) {
        if (this.getShell() != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DlgProgressMonitor.this.setOperationCancelButtonEnabled(b);
                }
            });
        }
    }

    @Override
    protected void cancelPressed() {
        try {
            Session.getLastStatement().cancel();
        }
        catch (SQLException ex) {
            SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("CancelStatement"), new Object[0]);
        }
        this.cancel.setEnabled(false);
        this.progressMonitor.setCanceled(true);
        super.cancelPressed();
    }

    @Override
    public boolean close() {
        if (this.getNestingDepth() <= 0) {
            this.clearCursors();
            return super.close();
        }
        return false;
    }

    protected void clearCursors() {
        Shell shell;
        if (this.cancel != null && !this.cancel.isDisposed()) {
            this.cancel.setCursor(null);
        }
        if ((shell = this.getShell()) != null && !shell.isDisposed()) {
            shell.setCursor(null);
        }
        if (this.arrowCursor != null) {
            this.arrowCursor.dispose();
        }
        if (this.waitCursor != null) {
            this.waitCursor.dispose();
        }
        this.arrowCursor = null;
        this.waitCursor = null;
    }

    @Override
    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(JFaceResources.getString("ProgressMonitorDialog.title"));
        if (this.waitCursor == null) {
            this.waitCursor = new Cursor((Device)shell.getDisplay(), 1);
        }
        shell.setCursor(this.waitCursor);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createCancelButton(parent);
    }

    protected void createCancelButton(Composite parent) {
        this.cancel = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        if (this.arrowCursor == null) {
            this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
        }
        this.cancel.setCursor(this.arrowCursor);
        this.setOperationCancelButtonEnabled(this.enableCancelButton);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setMessage(DEFAULT_TASKNAME);
        this.createMessageArea(parent);
        this.taskLabel = this.messageLabel;
        this.progressIndicator = new ProgressIndicator(parent);
        GridData gd = new GridData();
        int BAR_DLUS = 9;
        gd.heightHint = this.convertVerticalDLUsToPixels(BAR_DLUS);
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.progressIndicator.setLayoutData(gd);
        this.subTaskLabel = new Label(parent, 16448);
        gd = new GridData(768);
        int LABEL_DLUS = 21;
        gd.heightHint = this.convertVerticalDLUsToPixels(LABEL_DLUS);
        gd.horizontalSpan = 2;
        this.subTaskLabel.setLayoutData((Object)gd);
        this.subTaskLabel.setFont(parent.getFont());
        return parent;
    }

    @Override
    protected Point getInitialSize() {
        Point calculatedSize = super.getInitialSize();
        if (calculatedSize.x < 450) {
            calculatedSize.x = 450;
        }
        return calculatedSize;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.setCancelable(cancelable);
        try {
            this.aboutToRun();
            this.progressMonitor.forked = fork;
            ModalContext.run(runnable, fork, this.getProgressMonitor(), this.getShell().getDisplay());
        }
        finally {
            this.finishedRun();
        }
    }

    public boolean getOpenOnRun() {
        return this.openOnRun;
    }

    public void setOpenOnRun(boolean openOnRun) {
        this.openOnRun = openOnRun;
    }

    protected int getNestingDepth() {
        return this.nestingDepth;
    }

    protected void incrementNestingDepth() {
        ++this.nestingDepth;
    }

    protected void decrementNestingDepth() {
        --this.nestingDepth;
    }

    protected void aboutToRun() {
        if (this.getOpenOnRun()) {
            this.open();
        } else {
            this.create();
        }
        this.incrementNestingDepth();
    }

    protected void finishedRun() {
        this.decrementNestingDepth();
        this.close();
    }

    public void setCancelable(boolean cancelable) {
        if (this.cancel == null) {
            this.enableCancelButton = cancelable;
        } else {
            this.asyncSetOperationCancelButtonEnabled(cancelable);
        }
    }

    protected void setOperationCancelButtonEnabled(boolean b) {
        this.operationCancelableState = b;
        this.cancel.setEnabled(b);
    }

    @Override
    protected Image getImage() {
        return this.getInfoImage();
    }

    private void setMessage(String messageString) {
        String string = this.message = messageString == null ? "" : messageString;
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.setText(DlgProgressMonitor.shortenText(this.message, (Control)this.messageLabel));
    }

    private void update() {
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        this.messageLabel.update();
    }

    @Override
    public int open() {
        if (!this.getOpenOnRun() && this.getNestingDepth() == 0) {
            return 0;
        }
        return super.open();
    }

    private class ProgressMonitor
    implements IProgressMonitorWithBlocking {
        protected boolean forked = false;
        protected boolean locked = false;
        private boolean fIsCanceled;

        private ProgressMonitor() {
        }

        @Override
        public void beginTask(String name, int totalWork) {
            if (DlgProgressMonitor.this.progressIndicator.isDisposed()) {
                return;
            }
            if (name == null) {
                DlgProgressMonitor.this.task = "";
            } else {
                DlgProgressMonitor.this.task = name;
            }
            String s = DlgProgressMonitor.this.task;
            if (s.length() <= 0) {
                s = DEFAULT_TASKNAME;
            }
            DlgProgressMonitor.this.setMessage(s);
            if (!this.forked) {
                DlgProgressMonitor.this.update();
            }
            if (totalWork == -1) {
                DlgProgressMonitor.this.progressIndicator.beginAnimatedTask();
            } else {
                DlgProgressMonitor.this.progressIndicator.beginTask(totalWork);
            }
        }

        @Override
        public void done() {
            if (!DlgProgressMonitor.this.progressIndicator.isDisposed()) {
                DlgProgressMonitor.this.progressIndicator.sendRemainingWork();
                DlgProgressMonitor.this.progressIndicator.done();
                DlgProgressMonitor.this.finishedRun();
            }
        }

        @Override
        public void setTaskName(String name) {
            if (name == null) {
                DlgProgressMonitor.this.task = "";
            } else {
                DlgProgressMonitor.this.task = name;
            }
            String s = DlgProgressMonitor.this.task;
            if (s.length() <= 0) {
                s = DEFAULT_TASKNAME;
            }
            DlgProgressMonitor.this.setMessage(s);
            if (!this.forked) {
                DlgProgressMonitor.this.update();
            }
        }

        @Override
        public boolean isCanceled() {
            return this.fIsCanceled;
        }

        @Override
        public void setCanceled(boolean b) {
            this.fIsCanceled = b;
            if (this.locked) {
                this.clearBlocked();
            }
        }

        @Override
        public void subTask(String name) {
            if (DlgProgressMonitor.this.subTaskLabel.isDisposed()) {
                return;
            }
            String fSubTask = "";
            fSubTask = name == null ? "" : name;
            DlgProgressMonitor.this.subTaskLabel.setText(Dialog.shortenText(fSubTask, (Control)DlgProgressMonitor.this.subTaskLabel));
            if (!this.forked) {
                DlgProgressMonitor.this.subTaskLabel.update();
            }
        }

        @Override
        public void worked(int work) {
            this.internalWorked(work);
        }

        @Override
        public void internalWorked(double work) {
            if (!DlgProgressMonitor.this.progressIndicator.isDisposed()) {
                DlgProgressMonitor.this.progressIndicator.worked(work);
            }
        }

        @Override
        public void clearBlocked() {
            this.locked = false;
            DlgProgressMonitor.this.updateForClearBlocked();
        }

        @Override
        public void setBlocked(IStatus reason) {
            this.locked = true;
            DlgProgressMonitor.this.updateForSetBlocked(reason);
        }
    }
}

