/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.gui;

import eelk.koguja.gui.DlgProgressMonitor;
import eelk.koguja.util.Resources;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DlgProgress
extends DlgProgressMonitor
implements Runnable {
    private int popupDelay = 0;
    private volatile boolean running = false;
    private final Cursor busyCursor = null;

    public DlgProgress(Shell shell) {
        super(shell);
    }

    @Override
    protected void createCancelButton(Composite parent) {
        super.createCancelButton(parent);
        this.cancel.setText(Resources.getString("Gen.Cancel"));
    }

    @Override
    protected void aboutToRun() {
        this.running = true;
        if (this.isPopupDelay()) {
            this.setCursorBusy(true);
            this.getShell().getDisplay().timerExec(this.popupDelay, (Runnable)this);
        }
        super.aboutToRun();
    }

    private boolean isPopupDelay() {
        return !this.getOpenOnRun() && this.popupDelay > 0;
    }

    private void setCursorBusy(boolean busy) {
        Display d = this.getParentShell().getDisplay();
        if (this.busyCursor != null) {
            this.busyCursor.dispose();
        }
        Cursor c = busy ? new Cursor((Device)d, 1) : null;
        Shell s = this.getParentShell();
        if (s != null) {
            s.setCursor(c);
        }
    }

    public int getPopupDelay() {
        return this.popupDelay;
    }

    public void setPopupDelay(int popupDelay) {
        this.popupDelay = popupDelay;
    }

    @Override
    public void run() {
        if (this.running && this.isPopupDelay()) {
            this.open();
        }
    }

    @Override
    protected void finishedRun() {
        this.running = false;
        if (this.isPopupDelay()) {
            this.setCursorBusy(false);
        }
        super.finishedRun();
    }
}

