/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.gui;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.TypedListener;

public class ArrowButton
extends Composite
implements SelectionListener {
    private boolean alwaysShowPopup = false;
    private int selectedIndex = -1;
    private Button btnText;
    private Button btnArrow;
    private Menu miPopupList;

    public ArrowButton(Composite parent, int style) {
        super(parent, style);
        this.initControls();
    }

    public boolean getAlwaysShowPopup() {
        return this.alwaysShowPopup;
    }

    public void setAlwaysShowPopup(boolean value) {
        this.alwaysShowPopup = value;
    }

    public String getText() {
        return this.btnText.getText();
    }

    public void setText(String text) {
        this.btnText.setText(text);
    }

    public void addPopupItem(String text) {
        MenuItem mi = new MenuItem(this.miPopupList, 0);
        mi.setText(text);
        mi.addSelectionListener((SelectionListener)this);
        mi.setData((Object)(this.miPopupList.getItemCount() - 1));
    }

    public String getPopupItem(int index) {
        return this.miPopupList.getItem(index).getText();
    }

    public void setPopupItem(int index, String text) {
        this.miPopupList.getItem(index).setText(text);
    }

    public String removePopupItem(int index) {
        String result = this.miPopupList.getItem(index).getText();
        this.miPopupList.getItem(index).dispose();
        return result;
    }

    public void removeAllPopupitems() {
        this.miPopupList = new Menu((Control)this);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.btnArrow.equals(e.getSource()) || this.getAlwaysShowPopup() && this.btnText.equals(e.getSource())) {
            this.miPopupList.setVisible(true);
        } else if (this.btnText.equals(e.getSource()) && !this.getAlwaysShowPopup()) {
            this.selectedIndex = -1;
            this.notifyListeners(13, new Event());
        } else if (e.getSource() instanceof MenuItem) {
            this.selectedIndex = (Integer)((MenuItem)e.getSource()).getData();
            this.notifyListeners(13, new Event());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    protected void initControls() {
        this.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.btnArrow = new Button((Composite)this, 1028);
        this.btnArrow.setLayoutData((Object)formData);
        this.btnArrow.addSelectionListener((SelectionListener)this);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.btnArrow);
        formData.bottom = new FormAttachment(100, 0);
        this.btnText = new Button((Composite)this, 8);
        this.btnText.setLayoutData((Object)formData);
        this.btnText.addSelectionListener((SelectionListener)this);
        this.miPopupList = new Menu((Control)this);
    }

    public void setEnabled(boolean value) {
        this.btnText.setEnabled(value);
        this.btnArrow.setEnabled(value);
    }
}

