/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.events;

import eelk.koguja.events.IBusinessObjectListener;
import eelk.koguja.model.BusinessObject;
import java.util.LinkedList;
import java.util.List;

public class BusinessObjectEventFactory {
    private static final List<IBusinessObjectListener> listeners = new LinkedList<IBusinessObjectListener>();

    public static void addListener(IBusinessObjectListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void notifyCreateListeners(BusinessObject object, Object ... data) {
        for (IBusinessObjectListener listener : listeners) {
            listener.businessObjectCreated(object, data);
        }
    }

    public static void notifyModifyListeners(BusinessObject object) {
        for (IBusinessObjectListener listener : listeners) {
            listener.businessObjectModified(object);
        }
    }

    public static void notifyDeleteListeners(BusinessObject object) {
        for (IBusinessObjectListener listener : listeners) {
            listener.businessObjectDeleted(object);
        }
    }
}

