/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.dlg.OKCancelDialog;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VAddModDel;
import eelk.koguja.view.VUsers;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DlgUsers
extends OKCancelDialog {
    private static final Logger logger = Logger.getLogger(DlgUsers.class);
    private static final int MIN_WIDTH = 800;
    private static final int MIN_HEIGHT = 500;
    private VUsers vwUsers;

    public DlgUsers(Shell parentShell) {
        super(parentShell);
    }

    public DlgUsers(IShellProvider parent) {
        super(parent);
    }

    @Override
    public Control createContents(Composite parent) {
        this.getShell().setText(Resources.getString("DlgUsers"));
        this.getShell().setMinimumSize(800, 500);
        this.createDialogArea(parent);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getString("Msg.LoadingUsers"), -1);
                try {
                    DlgUsers.this.vwUsers.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.vwUsers.refresh();
        return parent;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.vwUsers = new VUsers(parent, 0);
        this.vwUsers.setLayoutData(new GridData(1808));
        VAddModDel cmpButtons = new VAddModDel(parent, 0);
        this.vwUsers.setButtonsPanel(cmpButtons);
        return parent;
    }
}

