/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.dlg.OKCancelDialog;
import eelk.koguja.util.Resources;
import eelk.koguja.view.VQuestionOption;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DlgSelectEvent
extends OKCancelDialog {
    private static final int MIN_WIDTH = 360;
    private static final int MIN_HEIGHT = 180;
    private SelectEventResult eventResult = SelectEventResult.NONE;
    private boolean canUseFound = true;
    private VQuestionOption vwQuestionOptions;

    public DlgSelectEvent(Shell parentShell) {
        super(parentShell);
    }

    public DlgSelectEvent(IShellProvider provider) {
        super(provider);
    }

    public SelectEventResult getEventResult() {
        return this.eventResult;
    }

    public void setCanUseFound(boolean value) {
        this.canUseFound = value;
        if (this.vwQuestionOptions != null && !this.vwQuestionOptions.isDisposed()) {
            this.vwQuestionOptions.setAnswerEnabled(0, value);
        }
    }

    @Override
    public Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.getShell().setText(Resources.getString("DlgSelectEvent"));
        this.getShell().setMinimumSize(360, 180);
        return panel;
    }

    @Override
    protected void okPressed() {
        switch (this.vwQuestionOptions.getSelectedAnswer()) {
            case 0: {
                this.eventResult = SelectEventResult.USE_FOUND;
                break;
            }
            case 1: {
                this.eventResult = SelectEventResult.CREATE_NEW;
            }
        }
        super.okPressed();
    }

    @Override
    protected void cancelPressed() {
        this.eventResult = SelectEventResult.NONE;
        super.cancelPressed();
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        int options = 2;
        this.vwQuestionOptions = new VQuestionOption(panel, 2);
        this.vwQuestionOptions.setLayoutData(new GridData(1808));
        this.vwQuestionOptions.setQuestion(this.canUseFound ? "DlgSelectEvent.lblQuestion.Found" : "DlgSelectEvent.lblQuestion.NotFound");
        this.vwQuestionOptions.setAnswer(0, Resources.getString("DlgSelectEvent.btnUseFound"));
        this.vwQuestionOptions.setAnswer(1, Resources.getString("DlgSelectEvent.btnCreateNew"));
        this.vwQuestionOptions.setAnswerEnabled(0, this.canUseFound);
        return parent;
    }

    public static enum SelectEventResult {
        NONE(0),
        USE_FOUND(1),
        CREATE_NEW(2);

        private final int type;

        private SelectEventResult(int type) {
            this.type = type;
        }

        int getType() {
            return this.type;
        }
    }
}

