/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.Session;
import eelk.koguja.dlg.OKCancelDialog;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VRelationship;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DlgRelationship
extends OKCancelDialog {
    private static final Logger logger = Logger.getLogger(DlgRelationship.class);
    private static final int MIN_WIDTH = 750;
    private static final int MIN_HEIGHT = 400;
    private boolean loadSucceeded;
    private boolean saveSucceeded;
    private VRelationship vwRelationship;

    public DlgRelationship(Shell parentShell) {
        super(parentShell);
    }

    public DlgRelationship(IShellProvider parent) {
        super(parent);
    }

    public VRelationship getView() {
        return this.vwRelationship;
    }

    @Override
    public int open() {
        if (this.getView() == null || this.getView().isDisposed()) {
            this.create();
        }
        return this.load() ? super.open() : 1;
    }

    @Override
    public Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.getShell().setText(Resources.getString("DlgRelationship"));
        this.getShell().setMinimumSize(750, 400);
        this.createButton((Composite)this.getButtonBar(), 2, Resources.getString("DlgRelationship.btnEndRelationship"), false);
        return panel;
    }

    @Override
    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 2) {
            this.getView().endRelationship();
            if (this.save()) {
                this.setReturnCode(0);
                this.close();
            }
        }
    }

    @Override
    protected void okPressed() {
        if (this.getView().collect() && this.save()) {
            this.close();
        }
    }

    private boolean load() {
        this.loadSucceeded = false;
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    DlgRelationship.this.getView().load(p);
                    Session.connection().commit();
                    DlgRelationship.this.loadSucceeded = true;
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                    DlgRelationship.this.loadSucceeded = false;
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                    DlgRelationship.this.loadSucceeded = false;
                }
            }
        });
        this.getView().refresh();
        return this.loadSucceeded;
    }

    private boolean save() {
        this.saveSucceeded = false;
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    DlgRelationship.this.saveSucceeded = DlgRelationship.this.getView().save(p);
                    Session.connection().commit();
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save"), new Object[0]);
                    DlgRelationship.this.saveSucceeded = false;
                }
            }
        });
        return this.saveSucceeded;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)panel.getLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.vwRelationship = new VRelationship(panel);
        this.vwRelationship.setLayoutData(new GridData(1808));
        return panel;
    }
}

