/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.dlg.OKCancelDialog;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VPersonGroup;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DlgPersonGroup
extends OKCancelDialog {
    private static final Logger logger = Logger.getLogger(DlgPersonGroup.class);
    private static final int MIN_WIDTH = 500;
    private static final int MIN_HEIGHT = 350;
    private final int personId;
    private VPersonGroup vwPersonGroup;

    public DlgPersonGroup(IShellProvider parentShell, int personId) {
        super(parentShell);
        this.personId = personId;
    }

    @Override
    public Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.getShell().setText(Resources.getString("DlgPersonGroup"));
        this.getShell().setMinimumSize(500, 350);
        return panel;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)panel.getLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.vwPersonGroup = new VPersonGroup(panel);
        this.vwPersonGroup.setLayoutData(new GridData(1808));
        this.vwPersonGroup.setObjectID(this.personId);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                try {
                    DlgPersonGroup.this.vwPersonGroup.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.vwPersonGroup.refresh();
        return panel;
    }

    @Override
    public void okPressed() {
        if (!this.vwPersonGroup.collect()) {
            return;
        }
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                try {
                    DlgPersonGroup.this.vwPersonGroup.save(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Save"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        super.okPressed();
    }
}

