/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.Session;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dlg.DlgComment;
import eelk.koguja.dlg.DlgEdit;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.preference.IPreferenceStore;
import eelk.koguja.preference.Preferences;
import eelk.koguja.search.PersonResult;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqCanSave;
import eelk.koguja.seq.SeqCanSavePerson;
import eelk.koguja.seq.SeqReportPersonDetails;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VPersonEdit;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DlgPersonEdit
extends DlgEdit {
    private static final Logger logger = Logger.getLogger(DlgPersonEdit.class);
    private static final int MIN_WIDTH = 610;
    private static final int MIN_HEIGHT = 640;
    private static final String PERSON_EDIT_WIDTH = "person_edit.width";
    private static final String PERSON_EDIT_HEIGHT = "person_edit.height";
    private static final String PERSON_EDIT_X = "person_edit.x";
    private static final String PERSON_EDIT_Y = "person_edit.y";
    private boolean loadSucceeded;
    private boolean saveSucceeded;
    private SeqCanSavePerson seqCanSavePerson;
    private VPersonEdit vwPersonEdit;

    public DlgPersonEdit(Shell parentShell) {
        super(parentShell);
    }

    public DlgPersonEdit(IShellProvider parent) {
        super(parent);
    }

    @Override
    public int open() {
        if (this.getView() == null || this.getView().isDisposed()) {
            this.create();
        }
        return this.load() ? super.open() : 1;
    }

    public VPersonEdit getView() {
        return this.vwPersonEdit;
    }

    @Override
    public Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.getShell().setMinimumSize(610, 640);
        IPreferenceStore store = Preferences.getStore();
        if (store.contains(PERSON_EDIT_WIDTH) && store.contains(PERSON_EDIT_HEIGHT)) {
            this.getShell().setSize(store.getInt(PERSON_EDIT_WIDTH), store.getInt(PERSON_EDIT_HEIGHT));
        }
        if (store.contains(PERSON_EDIT_X) && store.contains(PERSON_EDIT_Y)) {
            this.getShell().setLocation(store.getInt(PERSON_EDIT_X), store.getInt(PERSON_EDIT_Y));
        }
        return panel;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.vwPersonEdit = new VPersonEdit(parent);
        this.vwPersonEdit.setLayoutData(new GridData(1808));
        return parent;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Resources.getGenString("Save"), false);
        this.createButton(parent, 2, Resources.getString("DlgPersonEdit.btnReport"), false);
        this.createButton(parent, 1, Resources.getGenString("Cancel"), false);
    }

    @Override
    protected void savePreferences() {
        super.savePreferences();
        IPreferenceStore store = Preferences.getStore();
        store.setValue(PERSON_EDIT_WIDTH, this.getShell().getSize().x);
        store.setValue(PERSON_EDIT_HEIGHT, this.getShell().getSize().y);
        store.setValue(PERSON_EDIT_X, this.getShell().getLocation().x);
        store.setValue(PERSON_EDIT_Y, this.getShell().getLocation().y);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 2 && this.vwPersonEdit.collect()) {
            boolean nochanges = false;
            if (this.vwPersonEdit.getMode().equals((Object)ISave.SaveMode.SaveAdd) || this.vwPersonEdit.getMode().equals((Object)ISave.SaveMode.SaveUpdate) && this.vwPersonEdit.hasChanged()) {
                if (GuiUtil.confirmationDialog(this.getShell(), "Msg.Confirm.Save")) {
                    this.okPressed();
                }
            } else {
                super.okPressed();
                nochanges = true;
            }
            if (this.saveSucceeded || nochanges) {
                ArrayList<Result> id = new ArrayList<Result>();
                id.add(new PersonResult(this.getView().getPerson(), null));
                Sequence.execSequence(new SeqReportPersonDetails(DlgMain.instance().getShell(), id, false));
            }
        }
    }

    @Override
    protected void okPressed() {
        if (this.vwPersonEdit.collect()) {
            DlgComment dlg = new DlgComment(this);
            boolean save = true;
            if (this.vwPersonEdit.getMode().equals((Object)ISave.SaveMode.SaveAdd)) {
                save = true;
            } else if (this.vwPersonEdit.getMode().equals((Object)ISave.SaveMode.SaveUpdate) && this.vwPersonEdit.hasChanged()) {
                if (dlg.open() == 0) {
                    this.vwPersonEdit.getPerson().setModifiedComment(dlg.getCommentText());
                    save = true;
                } else {
                    save = false;
                }
            }
            if (save) {
                try {
                    List<String> personsCongregations = MPersonSwt.instance().getDuplicatePersonsCongregations(this.vwPersonEdit.getPerson().getFirstName(), this.vwPersonEdit.getPerson().getLastName(), this.vwPersonEdit.getPerson().getBirthDate(), this.vwPersonEdit.getPerson().getId());
                    if (personsCongregations.size() > 0) {
                        StringBuilder congregations = new StringBuilder();
                        for (int i = 0; i < personsCongregations.size(); ++i) {
                            congregations.append("\n").append(personsCongregations.get(i)).append(": ").append(this.vwPersonEdit.getPerson().getFirstName()).append(" ").append(this.vwPersonEdit.getPerson().getLastName()).append(", ").append(this.vwPersonEdit.getPerson().getBirthDate()).append(", ").append(this.vwPersonEdit.getPerson().getCode());
                        }
                        if (!GuiUtil.confirmationDialog(this.getShell(), "Err.VPersonEdit.DuplicatesFound", congregations.toString())) {
                            save = false;
                        }
                    }
                }
                catch (SQLException e) {
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Save"), new Object[0]);
                }
            }
            if (save && this.save()) {
                super.okPressed();
            }
        }
    }

    @Override
    protected void cancelPressed() {
        Session.rollback();
        super.cancelPressed();
    }

    private boolean load() {
        IRunnableWithProgress loadPerson = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    DlgPersonEdit.this.getView().load(p);
                    Session.connection().commit();
                    DlgPersonEdit.this.loadSucceeded = true;
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                    DlgPersonEdit.this.loadSucceeded = false;
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                    DlgPersonEdit.this.loadSucceeded = false;
                }
            }
        };
        Operation.run(this.getShell(), true, loadPerson);
        this.getView().refresh();
        return this.loadSucceeded;
    }

    private boolean save() {
        if (this.getView().getMode() == ISave.SaveMode.SaveUpdate) {
            if (this.seqCanSavePerson == null) {
                this.seqCanSavePerson = new SeqCanSavePerson(this.getShell());
            }
            this.seqCanSavePerson.setObject(this.getView().getPerson());
            Sequence.execSequence(this.seqCanSavePerson);
            if (this.seqCanSavePerson.getSaveAction() != SeqCanSave.SaveAction.Save) {
                return this.seqCanSavePerson.getSaveAction() == SeqCanSave.SaveAction.Skip;
            }
        }
        IRunnableWithProgress savePerson = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    DlgPersonEdit.this.saveSucceeded = DlgPersonEdit.this.getView().save(p);
                    Session.connection().commit();
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save"), new Object[0]);
                    DlgPersonEdit.this.saveSucceeded = false;
                }
            }
        };
        Operation.run(this.getShell(), true, savePerson);
        return this.saveSucceeded;
    }
}

