/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.Session;
import eelk.koguja.dlg.OKCancelDialog;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VPersonAccess;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DlgPersonAccess
extends OKCancelDialog {
    private static final Logger logger = Logger.getLogger(DlgPersonAccess.class);
    private static final int MIN_WIDTH = 350;
    private static final int MIN_HEIGHT = 500;
    private VPersonAccess vwPersonAccess;
    private final int personId;

    public DlgPersonAccess(Shell parentShell, int personId) {
        super(parentShell);
        this.personId = personId;
    }

    public DlgPersonAccess(IShellProvider parent, int personId) {
        super(parent);
        this.personId = personId;
    }

    @Override
    public Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.getShell().setText(Resources.getString("DlgPersonAccess"));
        this.getShell().setMinimumSize(350, 500);
        return panel;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)panel.getLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.vwPersonAccess = new VPersonAccess(panel);
        this.vwPersonAccess.setLayoutData(new GridData(1808));
        this.vwPersonAccess.setObjectID(this.personId);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                try {
                    DlgPersonAccess.this.vwPersonAccess.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.vwPersonAccess.refresh();
        return panel;
    }

    @Override
    public void okPressed() {
        if (!this.vwPersonAccess.collect()) {
            return;
        }
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                try {
                    DlgPersonAccess.this.vwPersonAccess.save(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Save"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        super.okPressed();
    }
}

