/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.Session;
import eelk.koguja.action.MainMenu;
import eelk.koguja.action.MainToolBar;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.seq.SeqLogin;
import eelk.koguja.seq.SeqLogout;
import eelk.koguja.seq.SeqModifyConnection;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VMain;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DlgMain
extends ApplicationWindow
implements ControlListener,
IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(DlgMain.class);
    private static DlgMain instance;
    private boolean confirmLogout = true;
    private Composite cmpForm;
    private VMain vwMain;

    private DlgMain() {
        super((Shell)null);
        this.addMenuBar();
        this.addCoolBar(8519744);
        this.addStatusLine();
        this.setBlockOnOpen(false);
    }

    public static DlgMain instance() {
        if (instance == null) {
            instance = new DlgMain();
        }
        return instance;
    }

    public VMain getVMain() {
        return this.vwMain;
    }

    @Override
    public int open() {
        super.open();
        return this.fireLogin();
    }

    public int fireLogin() {
        SeqLogin seqLogin = new SeqLogin(this.getShell());
        if (Sequence.execSequence(seqLogin) != Sequence.SeqResult.SeqCompleted) {
            this.setBlockOnOpen(false);
            this.confirmLogout = false;
            this.close();
            this.confirmLogout = true;
            return 1;
        }
        if (Session.current() == null) {
            SeqModifyConnection seqConnection = new SeqModifyConnection(this.getShell());
            Sequence.execSequence(seqConnection);
            return this.fireLogin();
        }
        this.setBlockOnOpen(true);
        this.updateTitle();
        this.loadInitialData();
        int x = super.open();
        logger.info("Main window closing");
        return x;
    }

    @Override
    public boolean close() {
        boolean confirm;
        boolean doLogout = Session.current() != null;
        boolean bl = confirm = Session.congregation() != null && this.confirmLogout;
        if (doLogout) {
            Sequence.SeqResult r = Sequence.execSequence(new SeqLogout(this.getShell(), confirm));
            if (r != Sequence.SeqResult.SeqCompleted) {
                return false;
            }
            this.getVMain().saveMainPreferences();
        }
        return super.close();
    }

    public void updateTitle() {
        DomCongregation d = Session.congregation();
        if (d == null) {
            this.getShell().setText(Resources.getString("VMain.TitleNoSession"));
        } else {
            this.getShell().setText(MessageFormat.format(Resources.getString("VMain.Title"), d.getName()));
        }
    }

    @Override
    public Control createContents(Composite parent) {
        this.cmpForm = (Composite)super.createContents(parent);
        this.cmpForm.setLocation(0, 0);
        this.cmpForm.setSize(this.getShell().getSize());
        this.cmpForm.setLayout((Layout)new FillLayout());
        this.getShell().setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        try {
            this.getSeperator1().setLayoutData((Object)formData);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)this.getSeperator1());
        formData.right = new FormAttachment(100, 0);
        this.getCoolBarControl().setLayoutData((Object)formData);
        Control statusline = this.getStatusLineManager().createControl(parent, 2048);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(100, -22);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        statusline.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(this.getCoolBarControl());
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(statusline, 0);
        this.cmpForm.setLayoutData((Object)formData);
        this.vwMain = new VMain(this.cmpForm, 0);
        this.getCoolBarControl().addControlListener((ControlListener)this);
        this.updateTitle();
        this.getShell().forceActive();
        return this.cmpForm;
    }

    private void loadInitialData() {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                try {
                    DlgMain.this.vwMain.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), false, r);
        this.vwMain.refresh();
    }

    public boolean getToolbarVisible() {
        return this.getCoolBarControl().getVisible();
    }

    public void setToolbarVisible(boolean value) {
        this.getCoolBarControl().setVisible(value);
        FormData formData = (FormData)this.cmpForm.getLayoutData();
        formData.top.control = value ? this.getCoolBarControl() : this.getSeperator1();
        this.getShell().layout();
    }

    public void setStatusLineMessage(String msg) {
        this.getStatusLineManager().setMessage(msg);
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.getCoolBarControl().equals(e.getSource())) {
            this.getShell().layout();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getProperty().equals("checked") && this.vwMain != null) {
            if (MainMenu.getViewToolbar().equals(e.getSource())) {
                this.setToolbarVisible((Boolean)e.getNewValue());
            } else if (MainMenu.getViewSearchPanel().equals(e.getSource())) {
                this.vwMain.setSearchVisible((Boolean)e.getNewValue());
            } else if (MainMenu.getViewNaviPanel().equals(e.getSource())) {
                this.vwMain.setNaviVisible((Boolean)e.getNewValue());
            } else if (MainMenu.getViewResultsPanel().equals(e.getSource())) {
                this.vwMain.setResultsVisible((Boolean)e.getNewValue());
            } else if (MainMenu.getViewPreviewPanel().equals(e.getSource())) {
                this.vwMain.setPreviewVisible((Boolean)e.getNewValue());
            }
        }
    }

    @Override
    protected CoolBarManager createCoolBarManager(int style) {
        CoolBarManager result = super.createCoolBarManager(style);
        result.add(MainToolBar.createFileToolBar(this, super.createToolBarManager(style)));
        result.add(MainToolBar.createEditToolBar(this, super.createToolBarManager(style)));
        result.add(MainToolBar.createPersonToolBar(this, super.createToolBarManager(style)));
        return result;
    }

    @Override
    protected MenuManager createMenuManager() {
        MenuManager menu = super.createMenuManager();
        menu.add(MainMenu.createFileMenu(this));
        MainMenu.getActFileModify().addPropertyChangeListener(this);
        menu.add(MainMenu.createEditMenu(this));
        menu.add(MainMenu.createViewMenu(this));
        MainMenu.getViewToolbar().addPropertyChangeListener(this);
        MainMenu.getViewSearchPanel().addPropertyChangeListener(this);
        MainMenu.getViewNaviPanel().addPropertyChangeListener(this);
        MainMenu.getViewResultsPanel().addPropertyChangeListener(this);
        MainMenu.getViewPreviewPanel().addPropertyChangeListener(this);
        menu.add(MainMenu.createReportMenu(this));
        menu.add(MainMenu.createAdminMenu(this));
        menu.add(MainMenu.createHelpMenu(this));
        return menu;
    }

    @Override
    protected void createStatusLine(Shell shell) {
        this.getStatusLineManager().createControl((Composite)shell, 2048);
    }
}

