/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.Session;
import eelk.koguja.dao.MGroupSwt;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.dlg.OKCancelDialog;
import eelk.koguja.model.DomGroup;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VGroupAdd;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DlgGroupAdd
extends OKCancelDialog
implements SelectionListener,
ModifyListener {
    private static final Logger logger = Logger.getLogger(DlgGroupAdd.class);
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 150;
    private VGroupAdd vwGroupAdd;

    public DlgGroupAdd(Shell parentShell) {
        super(parentShell);
    }

    public DlgGroupAdd(IShellProvider parent) {
        super(parent);
    }

    @Override
    public Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.getShell().setText(Resources.getString("DlgGroupAdd"));
        this.getShell().setMinimumSize(300, 150);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getString("Msg.LoadingGroupNames"), -1);
                try {
                    DlgGroupAdd.this.vwGroupAdd.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.vwGroupAdd.refresh();
        return panel;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        this.vwGroupAdd = new VGroupAdd(panel);
        this.vwGroupAdd.setLayoutData(new GridData(1808));
        this.vwGroupAdd.getCmbGroupType().addSelectionListener((SelectionListener)this);
        this.vwGroupAdd.getTxtGroupName().addModifyListener((ModifyListener)this);
        return panel;
    }

    @Override
    public void create() {
        super.create();
        this.checkMandatory();
    }

    @Override
    public void okPressed() {
        final DomGroup newGroup = this.vwGroupAdd.getGroup();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                try {
                    MGroupSwt.instance().create(newGroup);
                    p.done();
                    Session.connection().commit();
                    DlgMain.instance().getVMain().setGroups(MGroupSwt.listGroups(Session.current().getCongregation().getId()));
                    DlgMain.instance().getVMain().refresh();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Save"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        super.okPressed();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.checkMandatory();
    }

    public void modifyText(ModifyEvent e) {
        this.checkMandatory();
    }

    private void checkMandatory() {
        boolean ok = this.vwGroupAdd.isMandatoryFilled();
        this.getButton(0).setEnabled(ok);
    }
}

