/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.util.GuiUtil;
import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class DlgFileDialog {
    private final FileDialog dlg;

    public DlgFileDialog(Shell shell) {
        this.dlg = new FileDialog(shell);
    }

    public DlgFileDialog(Shell shell, int style) {
        this.dlg = new FileDialog(shell, style);
    }

    public String open() {
        if (this.dlg.getStyle() != 8192) {
            return this.dlg.open();
        }
        String fileName = null;
        boolean done = false;
        while (!done) {
            fileName = this.dlg.open();
            if (fileName == null) {
                done = true;
                continue;
            }
            File file = new File(fileName);
            if (file.exists()) {
                done = GuiUtil.confirmationDialog(this.dlg.getParent(), "Msg.ConfirmOverwriteFile", fileName);
                continue;
            }
            done = true;
        }
        return fileName;
    }

    public String getFileName() {
        return this.dlg.getFileName();
    }

    public void setFileName(String string) {
        this.dlg.setFileName(string);
    }

    public String[] getFileNames() {
        return this.dlg.getFileNames();
    }

    public String[] getFilterExtensions() {
        return this.dlg.getFilterExtensions();
    }

    public void setFilterExtensions(String[] extensions) {
        this.dlg.setFilterExtensions(extensions);
    }

    public String[] getFilterNames() {
        return this.dlg.getFilterNames();
    }

    public void setFilterNames(String[] names) {
        this.dlg.setFilterNames(names);
    }

    public String getFilterPath() {
        return this.dlg.getFilterPath();
    }

    public void setFilterPath(String string) {
        this.dlg.setFilterPath(string);
    }

    public Shell getParent() {
        return this.dlg.getParent();
    }

    public int getStyle() {
        return this.dlg.getStyle();
    }

    public String getText() {
        return this.dlg.getText();
    }

    public void setText(String string) {
        this.dlg.setText(string);
    }
}

