/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.Session;
import eelk.koguja.dlg.DlgComment;
import eelk.koguja.dlg.DlgEdit;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.preference.IPreferenceStore;
import eelk.koguja.preference.Preferences;
import eelk.koguja.search.DonationResult;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqCanSave;
import eelk.koguja.seq.SeqCanSaveDonation;
import eelk.koguja.seq.SeqReportDonationDetails;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VDonationEdit;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DlgDonationEdit
extends DlgEdit {
    private static final Logger logger = Logger.getLogger(DlgDonationEdit.class);
    private static final int MIN_WIDTH = 730;
    private static final int MIN_HEIGHT = 555;
    private static final String DONATION_EDIT_WIDTH = "donation_edit.width";
    private static final String DONATION_EDIT_HEIGHT = "donation_edit.height";
    private static final String DONATION_EDIT_X = "donation_edit.x";
    private static final String DONATION_EDIT_Y = "donation_edit.y";
    private boolean loadSucceeded;
    private boolean saveSucceeded;
    private SeqCanSaveDonation seqCanSaveDonation;
    private VDonationEdit vwDonationEdit;

    public DlgDonationEdit(Shell parentShell) {
        super(parentShell);
    }

    public DlgDonationEdit(IShellProvider modalParent) {
        super(modalParent);
    }

    public VDonationEdit getView() {
        return this.vwDonationEdit;
    }

    @Override
    public int open() {
        if (this.getView() == null || this.getView().isDisposed()) {
            this.create();
        }
        return this.load() ? super.open() : 1;
    }

    @Override
    public Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.getShell().setText(Resources.getString("DlgDonationEdit"));
        this.getShell().setMinimumSize(730, 555);
        IPreferenceStore store = Preferences.getStore();
        if (store.contains(DONATION_EDIT_WIDTH) && store.contains(DONATION_EDIT_HEIGHT)) {
            this.getShell().setSize(store.getInt(DONATION_EDIT_WIDTH), store.getInt(DONATION_EDIT_HEIGHT));
        }
        if (store.contains(DONATION_EDIT_X) && store.contains(DONATION_EDIT_Y)) {
            this.getShell().setLocation(store.getInt(DONATION_EDIT_X), store.getInt(DONATION_EDIT_Y));
        }
        return panel;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        this.vwDonationEdit = new VDonationEdit(panel);
        this.vwDonationEdit.setLayoutData(new GridData(1808));
        return panel;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Resources.getGenString("Save"), false);
        this.createButton(parent, 2, Resources.getString("DlgDonationEdit.btnOrder"), false);
        this.createButton(parent, 1, Resources.getGenString("Cancel"), false);
    }

    @Override
    protected void savePreferences() {
        super.savePreferences();
        IPreferenceStore store = Preferences.getStore();
        store.setValue(DONATION_EDIT_WIDTH, this.getShell().getSize().x);
        store.setValue(DONATION_EDIT_HEIGHT, this.getShell().getSize().y);
        store.setValue(DONATION_EDIT_X, this.getShell().getLocation().x);
        store.setValue(DONATION_EDIT_Y, this.getShell().getLocation().y);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 2) {
            this.okPressed();
            if (this.saveSucceeded) {
                ArrayList<Result> id = new ArrayList<Result>();
                id.add(new DonationResult(this.getView().getDonation(), null, null));
                Sequence.execSequence(new SeqReportDonationDetails(DlgMain.instance().getShell(), id, false));
            }
        }
    }

    @Override
    protected void okPressed() {
        if (this.getView().collect()) {
            DlgComment dlg = new DlgComment(this);
            boolean save = false;
            if (this.getView().askCommentOnSave()) {
                if (dlg.open() == 0) {
                    this.getView().getDonation().setModifiedComment(dlg.getCommentText());
                    save = true;
                }
            } else {
                save = true;
            }
            if (save && this.save()) {
                super.okPressed();
            }
        }
    }

    private boolean load() {
        IRunnableWithProgress loadDonation = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    DlgDonationEdit.this.getView().load(p);
                    Session.connection().commit();
                    DlgDonationEdit.this.loadSucceeded = true;
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                    DlgDonationEdit.this.loadSucceeded = false;
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                    DlgDonationEdit.this.loadSucceeded = false;
                }
            }
        };
        Operation.run(this.getShell(), true, loadDonation);
        this.getView().refresh();
        return this.loadSucceeded;
    }

    private boolean save() {
        if (this.getView().getMode() == ISave.SaveMode.SaveUpdate) {
            if (this.seqCanSaveDonation == null) {
                this.seqCanSaveDonation = new SeqCanSaveDonation(this.getShell());
            }
            this.seqCanSaveDonation.setObject(this.getView().getDonation());
            Sequence.execSequence(this.seqCanSaveDonation);
            if (this.seqCanSaveDonation.getSaveAction() != SeqCanSave.SaveAction.Save) {
                return this.seqCanSaveDonation.getSaveAction() == SeqCanSave.SaveAction.Skip;
            }
        }
        IRunnableWithProgress saveDonation = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    DlgDonationEdit.this.saveSucceeded = DlgDonationEdit.this.getView().save(p);
                    Session.connection().commit();
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save"), new Object[0]);
                    DlgDonationEdit.this.saveSucceeded = false;
                }
            }
        };
        Operation.run(this.getShell(), true, saveDonation);
        return this.saveSucceeded;
    }
}

