/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.dlg.OKCancelDialog;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VConnectionEdit;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DlgConnectionEdit
extends OKCancelDialog {
    private static final Logger logger = Logger.getLogger(DlgConnectionEdit.class);
    private static final int MIN_WIDTH = 342;
    private static final int MIN_HEIGHT = 243;
    private boolean saveSucceeded;
    private boolean loadSucceeded;
    private VConnectionEdit vwConnectionEdit;

    public DlgConnectionEdit(Shell parentShell) {
        super(parentShell);
    }

    public DlgConnectionEdit(IShellProvider provider) {
        super(provider);
    }

    public VConnectionEdit getView() {
        return this.vwConnectionEdit;
    }

    @Override
    public int open() {
        return this.load() ? super.open() : 1;
    }

    @Override
    public Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.getShell().setText(Resources.getString("DlgEditConnection"));
        this.getShell().setMinimumSize(342, 243);
        return panel;
    }

    @Override
    protected void okPressed() {
        if (!this.getView().collect()) {
            return;
        }
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Save.Saving"), -1);
                    DlgConnectionEdit.this.getView().save(p);
                    p.done();
                    DlgConnectionEdit.this.saveSucceeded = true;
                }
                catch (SQLException ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save"), new Object[0]);
                    DlgConnectionEdit.this.saveSucceeded = false;
                }
            }
        });
        if (this.saveSucceeded) {
            super.okPressed();
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        this.vwConnectionEdit = new VConnectionEdit(panel);
        this.vwConnectionEdit.setLayoutData(new GridData(1808));
        return panel;
    }

    private boolean load() {
        if (this.getView() == null || this.getView().isDisposed()) {
            this.create();
        }
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    DlgConnectionEdit.this.getView().load(p);
                    p.done();
                    DlgConnectionEdit.this.loadSucceeded = true;
                }
                catch (Exception ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                    DlgConnectionEdit.this.loadSucceeded = false;
                }
            }
        });
        if (this.loadSucceeded) {
            this.getView().refresh();
        }
        return this.loadSucceeded;
    }
}

