/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dlg;

import eelk.koguja.Session;
import eelk.koguja.dlg.DlgComment;
import eelk.koguja.dlg.DlgEdit;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.preference.IPreferenceStore;
import eelk.koguja.preference.Preferences;
import eelk.koguja.search.BaptismResult;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqCanSave;
import eelk.koguja.seq.SeqCanSaveBaptism;
import eelk.koguja.seq.SeqReportBaptismDetails;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VBaptismEdit;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DlgBaptismEdit
extends DlgEdit {
    private static final Logger logger = Logger.getLogger(DlgBaptismEdit.class);
    private static final int MIN_WIDTH = 730;
    private static final int MIN_HEIGHT = 760;
    private static final String BAPTISM_EDIT_WIDTH = "baptism_edit.width";
    private static final String BAPTISM_EDIT_HEIGHT = "baptism_edit.height";
    private static final String BAPTISM_EDIT_X = "baptism_edit.x";
    private static final String BAPTISM_EDIT_Y = "baptism_edit.y";
    private boolean loadSucceeded;
    private boolean saveSucceeded;
    private SeqCanSaveBaptism seqCanSaveBaptism;
    private VBaptismEdit vwBaptismEdit;

    public DlgBaptismEdit(Shell parentShell) {
        super(parentShell);
    }

    public DlgBaptismEdit(IShellProvider modalParent) {
        super(modalParent);
    }

    public VBaptismEdit getView() {
        return this.vwBaptismEdit;
    }

    @Override
    public int open() {
        if (this.getView() == null || this.getView().isDisposed()) {
            this.create();
        }
        return this.load() ? super.open() : 1;
    }

    @Override
    public Control createContents(Composite parent) {
        Composite panel = (Composite)super.createContents(parent);
        this.getShell().setText(Resources.getString("DlgBaptismEdit"));
        this.getShell().setMinimumSize(730, 760);
        IPreferenceStore store = Preferences.getStore();
        if (store.contains(BAPTISM_EDIT_WIDTH) && store.contains(BAPTISM_EDIT_HEIGHT)) {
            this.getShell().setSize(store.getInt(BAPTISM_EDIT_WIDTH), store.getInt(BAPTISM_EDIT_HEIGHT));
        }
        if (store.contains(BAPTISM_EDIT_X) && store.contains(BAPTISM_EDIT_Y)) {
            this.getShell().setLocation(store.getInt(BAPTISM_EDIT_X), store.getInt(BAPTISM_EDIT_Y));
        }
        return panel;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite panel = (Composite)super.createDialogArea(parent);
        this.vwBaptismEdit = new VBaptismEdit(panel);
        this.vwBaptismEdit.setLayoutData(new GridData(1808));
        return panel;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Resources.getGenString("Save"), false);
        this.createButton(parent, 2, Resources.getString("DlgBaptismEdit.btnReport"), false);
        this.createButton(parent, 1, Resources.getGenString("Cancel"), false);
    }

    @Override
    protected void savePreferences() {
        super.savePreferences();
        IPreferenceStore store = Preferences.getStore();
        store.setValue(BAPTISM_EDIT_WIDTH, this.getShell().getSize().x);
        store.setValue(BAPTISM_EDIT_HEIGHT, this.getShell().getSize().y);
        store.setValue(BAPTISM_EDIT_X, this.getShell().getLocation().x);
        store.setValue(BAPTISM_EDIT_Y, this.getShell().getLocation().y);
    }

    @Override
    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 2 && this.vwBaptismEdit.collect()) {
            boolean nochanges = false;
            if (this.vwBaptismEdit.getMode().equals((Object)ISave.SaveMode.SaveAdd) || this.vwBaptismEdit.getMode().equals((Object)ISave.SaveMode.SaveUpdate) && this.vwBaptismEdit.askCommentOnSave()) {
                if (GuiUtil.confirmationDialog(this.getShell(), "Msg.Confirm.Save")) {
                    this.okPressed();
                }
            } else {
                super.okPressed();
                nochanges = true;
            }
            if (this.saveSucceeded || nochanges) {
                ArrayList<Result> id = new ArrayList<Result>();
                id.add(new BaptismResult(this.getView().getBaptism()));
                Sequence.execSequence(new SeqReportBaptismDetails(DlgMain.instance().getShell(), id, false));
            }
        }
    }

    @Override
    protected void okPressed() {
        if (this.getView().collect()) {
            DlgComment dlg = new DlgComment(this);
            boolean save = false;
            if (this.getView().askCommentOnSave()) {
                if (dlg.open() == 0) {
                    this.getView().getBaptism().setModifiedComment(dlg.getCommentText());
                    save = true;
                }
            } else {
                save = true;
            }
            if (save && this.save()) {
                super.okPressed();
            }
        }
    }

    private boolean load() {
        this.loadSucceeded = false;
        IRunnableWithProgress loadPerson = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    DlgBaptismEdit.this.getView().load(p);
                    Session.connection().commit();
                    p.done();
                    DlgBaptismEdit.this.loadSucceeded = true;
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                    DlgBaptismEdit.this.loadSucceeded = false;
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                    DlgBaptismEdit.this.loadSucceeded = false;
                }
            }
        };
        Operation.run(this.getShell(), true, loadPerson);
        this.getView().refresh();
        return this.loadSucceeded;
    }

    private boolean save() {
        if (this.getView().getMode() == ISave.SaveMode.SaveUpdate) {
            if (this.seqCanSaveBaptism == null) {
                this.seqCanSaveBaptism = new SeqCanSaveBaptism(this.getShell());
            }
            this.seqCanSaveBaptism.setObject(this.getView().getBaptism());
            Sequence.execSequence(this.seqCanSaveBaptism);
            if (this.seqCanSaveBaptism.getSaveAction() != SeqCanSave.SaveAction.Save) {
                return this.seqCanSaveBaptism.getSaveAction() == SeqCanSave.SaveAction.Skip;
            }
        }
        this.saveSucceeded = false;
        IRunnableWithProgress savePerson = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    DlgBaptismEdit.this.saveSucceeded = DlgBaptismEdit.this.getView().save(p);
                    Session.connection().commit();
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save"), new Object[0]);
                    DlgBaptismEdit.this.saveSucceeded = false;
                }
            }
        };
        Operation.run(this.getShell(), true, savePerson);
        return this.saveSucceeded;
    }
}

