/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.MParticipant;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomParticipant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomWedding;
import eelk.koguja.model.DomWeddingHistory;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.WeddingExpression;
import eelk.koguja.search.WeddingResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MWedding
extends Model<DomWedding, WeddingExpression, WeddingResult> {
    private static MWedding theInstance;

    private MWedding() {
    }

    public static MWedding instance() {
        if (theInstance == null) {
            theInstance = new MWedding();
        }
        return theInstance;
    }

    public static DomWedding getWeddingForPerson(Date eventDate, DomPerson person) throws SQLException {
        String sql = String.format("SELECT * FROM v_my_weddings WHERE event_date = ? AND %1$S_id IS NULL AND %1$S_lastname = ? AND %1$S_firstname = ? AND %1$S_birthdate = ?", person.getSex() == 0 ? "groom" : "bride");
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setDate(1, eventDate);
        ps.setString(2, person.getLastName());
        ps.setString(3, person.getFirstName());
        ps.setDate(4, person.getBirthDate());
        ResultSet rs = ps.executeQuery();
        DomWedding result = rs.next() ? new DomWedding(rs) : null;
        rs.close();
        ps.close();
        return result;
    }

    public static DomWedding getWeddingForPerson(int personId) throws SQLException {
        String sql = "SELECT * FROM v_my_weddings WHERE bride_id = ? OR groom_id = ?  ORDER BY event_date DESC";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, personId);
        ps.setInt(2, personId);
        ResultSet rs = ps.executeQuery();
        DomWedding result = rs.next() ? new DomWedding(rs) : null;
        rs.close();
        ps.close();
        return result;
    }

    public static int createForPerson(DomWedding wedding) throws SQLException {
        String sql = "{? = call create_person_wedding(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, Session.current().getCongregation().getId());
        cs.setObject(3, (Object)wedding.getCongregationId(), 4);
        cs.setString(4, wedding.getCongregationName());
        cs.setObject(5, (Object)wedding.getState(), 4);
        cs.setDate(6, wedding.getEventDate());
        cs.setObject(7, (Object)wedding.getBrideId(), 4);
        cs.setString(8, wedding.getBrideFirstName());
        cs.setString(9, wedding.getBrideLastName());
        cs.setDate(10, wedding.getBrideBirthdate());
        cs.setString(11, wedding.getBrideCode());
        cs.setObject(12, (Object)wedding.getGroomId(), 4);
        cs.setString(13, wedding.getGroomFirstName());
        cs.setString(14, wedding.getGroomLastName());
        cs.setDate(15, wedding.getGroomBirthdate());
        cs.setString(16, wedding.getGroomCode());
        cs.setObject(17, (Object)wedding.isMarriageRegistered(), 16);
        cs.setObject(18, (Object)wedding.isMarriageConvetionVerified(), 16);
        cs.execute();
        int result = cs.getInt(1);
        if (cs.getObject(1) != null) {
            wedding.setId(result);
        }
        cs.close();
        return result;
    }

    public static void modifyForPerson(DomWedding wedding) throws SQLException {
        String sql = "{call modify_person_wedding(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, wedding.getId());
        cs.setObject(2, (Object)wedding.getCongregationId(), 4);
        cs.setString(3, wedding.getCongregationName());
        cs.setObject(4, (Object)wedding.getState(), 4);
        cs.setDate(5, wedding.getEventDate());
        cs.setObject(6, (Object)wedding.getBrideId(), 4);
        cs.setString(7, wedding.getBrideFirstName());
        cs.setString(8, wedding.getBrideLastName());
        cs.setDate(9, wedding.getBrideBirthdate());
        cs.setString(10, wedding.getBrideCode());
        cs.setObject(11, (Object)wedding.getGroomId(), 4);
        cs.setString(12, wedding.getGroomFirstName());
        cs.setString(13, wedding.getGroomLastName());
        cs.setDate(14, wedding.getGroomBirthdate());
        cs.setString(15, wedding.getGroomCode());
        cs.setObject(16, (Object)wedding.isMarriageRegistered(), 16);
        cs.setObject(17, (Object)wedding.isMarriageConvetionVerified(), 16);
        cs.execute();
        cs.close();
    }

    public static boolean isDirty(DomWedding wedding) throws SQLException {
        if (wedding == null) {
            return false;
        }
        DomWedding p = null;
        try {
            p = MWedding.instance().get(wedding.getId());
        }
        catch (ObjectNotFound e) {
            return false;
        }
        return wedding.getModified_on().before(p.getModified_on());
    }

    public static String getNextDocNr(Integer congregation) throws SQLException {
        String sql = "{? = call get_next_wedding_doc_nr(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 12);
        cs.setObject(2, (Object)congregation, 4);
        cs.execute();
        String result = cs.getString(1);
        cs.close();
        return result;
    }

    @Override
    public int create(DomWedding wedding) throws SQLException {
        String sql = "{? = call create_wedding(?, (select get_next_wedding_doc_nr(?)), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, Session.current().getCongregation().getId());
        if (wedding.getCongregationId() == null) {
            cs.setNull(3, 4);
            cs.setNull(4, 4);
        } else {
            cs.setInt(3, (int)wedding.getCongregationId());
            cs.setInt(4, (int)wedding.getCongregationId());
        }
        cs.setString(5, wedding.getCongregationName());
        cs.setDate(6, wedding.getApplicationDate());
        if (wedding.getState() == null) {
            cs.setNull(7, 4);
        } else {
            cs.setInt(7, (int)wedding.getState());
        }
        cs.setDate(8, wedding.getEventDate());
        cs.setDate(9, wedding.getEventFuzzyDate());
        cs.setTime(10, wedding.getEventStart());
        cs.setTime(11, wedding.getEventEnd());
        cs.setString(12, wedding.getScripturalPassage());
        cs.setString(13, wedding.getLegitimation());
        if (wedding.getOffciantId() == null) {
            cs.setNull(14, 4);
        } else {
            cs.setInt(14, (int)wedding.getOffciantId());
        }
        if (wedding.getLocationId() == null) {
            cs.setNull(15, 4);
        } else {
            cs.setInt(15, (int)wedding.getLocationId());
        }
        cs.setString(16, wedding.getComment());
        if (wedding.getBrideId() == null) {
            cs.setNull(17, 4);
        } else {
            cs.setInt(17, (int)wedding.getBrideId());
        }
        if (wedding.getBrideMaritalStatus() == null) {
            cs.setNull(18, 4);
        } else {
            cs.setInt(18, (int)wedding.getBrideMaritalStatus());
        }
        if (wedding.getGroomId() == null) {
            cs.setNull(19, 4);
        } else {
            cs.setInt(19, (int)wedding.getGroomId());
        }
        if (wedding.getGroomMaritalStatus() == null) {
            cs.setNull(20, 4);
        } else {
            cs.setInt(20, (int)wedding.getGroomMaritalStatus());
        }
        if (wedding.getNewCongregationId() == null) {
            cs.setNull(21, 4);
        } else {
            cs.setInt(21, (int)wedding.getNewCongregationId());
        }
        if (wedding.isMarriageRegistered() == null) {
            cs.setNull(22, 16);
        } else {
            cs.setBoolean(22, (boolean)wedding.isMarriageRegistered());
        }
        cs.setDate(23, wedding.getMarriageRegDate());
        cs.setString(24, wedding.getMarriageRegPlace());
        cs.setString(25, wedding.getMarriageCertNo());
        if (wedding.isMarriageConvetionVerified() == null) {
            cs.setNull(26, 16);
        } else {
            cs.setBoolean(26, (boolean)wedding.isMarriageConvetionVerified());
        }
        cs.setString(27, wedding.getBook());
        cs.setString(28, wedding.getPage());
        cs.execute();
        int result = cs.getInt(1);
        if (cs.getObject(1) != null) {
            wedding.setId(result);
        }
        cs.close();
        return result;
    }

    @Override
    public void modify(DomWedding wedding) throws SQLException {
        String sql = "{? = call modify_wedding(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setInt(2, wedding.getId());
        cs.setInt(3, Session.current().getCongregation().getId());
        if (wedding.getCongregationId() == null) {
            cs.setNull(4, 4);
        } else {
            cs.setInt(4, (int)wedding.getCongregationId());
        }
        cs.setString(5, wedding.getCongregationName());
        cs.setDate(6, wedding.getApplicationDate());
        if (wedding.getState() == null) {
            cs.setNull(7, 4);
        } else {
            cs.setInt(7, (int)wedding.getState());
        }
        cs.setDate(8, wedding.getEventDate());
        cs.setDate(9, wedding.getEventFuzzyDate());
        cs.setTime(10, wedding.getEventStart());
        cs.setTime(11, wedding.getEventEnd());
        cs.setString(12, wedding.getScripturalPassage());
        cs.setString(13, wedding.getLegitimation());
        if (wedding.getOffciantId() == null) {
            cs.setNull(14, 4);
        } else {
            cs.setInt(14, (int)wedding.getOffciantId());
        }
        if (wedding.getLocationId() == null) {
            cs.setNull(15, 4);
        } else {
            cs.setInt(15, (int)wedding.getLocationId());
        }
        cs.setString(16, wedding.getComment());
        if (wedding.getBrideId() == null) {
            cs.setNull(17, 4);
        } else {
            cs.setInt(17, (int)wedding.getBrideId());
        }
        if (wedding.getBrideMaritalStatus() == null) {
            cs.setNull(18, 4);
        } else {
            cs.setInt(18, (int)wedding.getBrideMaritalStatus());
        }
        if (wedding.getGroomId() == null) {
            cs.setNull(19, 4);
        } else {
            cs.setInt(19, (int)wedding.getGroomId());
        }
        if (wedding.getGroomMaritalStatus() == null) {
            cs.setNull(20, 4);
        } else {
            cs.setInt(20, (int)wedding.getGroomMaritalStatus());
        }
        if (wedding.getNewCongregationId() == null) {
            cs.setNull(21, 4);
        } else {
            cs.setInt(21, (int)wedding.getNewCongregationId());
        }
        if (wedding.isMarriageRegistered() == null) {
            cs.setNull(22, 16);
        } else {
            cs.setBoolean(22, (boolean)wedding.isMarriageRegistered());
        }
        cs.setDate(23, wedding.getMarriageRegDate());
        cs.setString(24, wedding.getMarriageRegPlace());
        cs.setString(25, wedding.getMarriageCertNo());
        if (wedding.isMarriageConvetionVerified() == null) {
            cs.setNull(26, 16);
        } else {
            cs.setBoolean(26, (boolean)wedding.isMarriageConvetionVerified());
        }
        cs.setString(27, wedding.getBook());
        cs.setString(28, wedding.getPage());
        cs.setString(29, wedding.getModifiedComment());
        cs.execute();
        cs.close();
    }

    @Override
    public DomWedding get(int objectID) throws SQLException, ObjectNotFound {
        DomWedding result = null;
        String sql = "SELECT * FROM v_my_weddings WHERE id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, objectID);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = new DomWedding(rs);
        }
        rs.close();
        ps.close();
        if (result == null) {
            throw new ObjectNotFound(objectID);
        }
        return result;
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{call delete_wedding(?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, objectID);
        cs.setInt(2, Session.congregation().getId());
        cs.execute();
        cs.close();
    }

    @Override
    public List<WeddingResult> search(WeddingExpression e) throws SQLException {
        String sql = "SELECT " + WeddingResult.getFields() + "   FROM f_search_wedding(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setString(1, Util.c((String)e.documentNumberFrom.getValue()));
        ps.setString(2, Util.c((String)e.documentNumberTo.getValue()));
        ps.setObject(3, e.congregation.getValue(), 4);
        ps.setObject(4, e.state.getValue(), 4);
        ps.setObject(5, e.stateExcept.getValue(), 4);
        ps.setDate(6, (Date)e.eventDateStart.getValue());
        ps.setDate(7, (Date)e.eventDateEnd.getValue());
        ps.setDate(8, (Date)e.appDateStart.getValue());
        ps.setDate(9, (Date)e.appDateEnd.getValue());
        ps.setTime(10, (Time)e.eventTimeStart.getValue());
        ps.setTime(11, (Time)e.eventTimeEnd.getValue());
        ps.setObject(12, e.place.getValue(), 4);
        ps.setString(13, Util.metaToDb((String)e.brideLastName.getValue()));
        ps.setString(14, Util.metaToDb((String)e.brideFirstName.getValue()));
        ps.setDate(15, (Date)e.brideBirthDate.getValue());
        ps.setString(16, Util.metaToDb((String)e.groomLastName.getValue()));
        ps.setString(17, Util.metaToDb((String)e.groomFirstName.getValue()));
        ps.setDate(18, (Date)e.groomBirthDate.getValue());
        ps.setString(19, Util.metaToDb(Util.c((String)e.participantFirstName.getValue())));
        ps.setString(20, Util.metaToDb(Util.c((String)e.participantLastName.getValue())));
        ResultSet rs = ps.executeQuery();
        List<WeddingResult> list = WeddingResult.fromResultSet(rs);
        rs.close();
        ps.close();
        return list;
    }

    public List<DomParticipant> getParticipants(Integer weddingId) throws SQLException {
        String sql = "SELECT * FROM v_weddings_participants WHERE wedding_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, weddingId);
        ResultSet rs = ps.executeQuery();
        List<DomParticipant> result = MParticipant.fromResultSet(rs, Util.createStringSet("id", "wedding_id", "person_id", "role_id", "person_firstname", "person_lastname", "person_deathdate"));
        rs.close();
        ps.close();
        return result;
    }

    public void setParticipants(Integer weddingId, List<DomParticipant> lstParts) throws SQLException {
        List<DomParticipant> lst = this.getParticipants(weddingId);
        String insSql = "{? = call create_wedding_participant(?, ?, ?, ?)}";
        String modSql = "{call modify_wedding_participant(?, ?, ?, ?, ?)}";
        String delSql = "{call delete_wedding_participant(?, ?)}";
        for (DomParticipant initPart : lst) {
            if (lstParts.contains(initPart)) continue;
            MParticipant.instance().deleteParticipant(initPart, "{call delete_wedding_participant(?, ?)}", weddingId);
        }
        block1: for (DomParticipant part : lstParts) {
            if (!lst.contains(part)) {
                MParticipant.instance().createParticipant(weddingId, part, "{? = call create_wedding_participant(?, ?, ?, ?)}");
                continue;
            }
            for (DomParticipant initPart : lst) {
                if (initPart.hasEqualFields(part)) break;
                if (!initPart.equals(part)) continue;
                MParticipant.instance().modifyParticipant(weddingId, part, "{call modify_wedding_participant(?, ?, ?, ?, ?)}");
                continue block1;
            }
        }
    }

    public List<DomWeddingHistory> getWeddingHistory(int weddingId) throws SQLException {
        String sql = " SELECT * FROM v_my_weddings_history WHERE wedding_id = ? ";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)weddingId, 4);
        ArrayList<DomWeddingHistory> result = new ArrayList<DomWeddingHistory>();
        ResultSet rs = ps.executeQuery();
        Set<String> cols = Util.createStringSet("id", "baptism_id", "congregation_id", "congregation_name", "application_date", "state", "event_date", "event_date_fuzzy_end", "event_start", "event_end", "donation_id", "scriptural_passage", "legitimation", "officiant_id", "location_id", "comment", "person_id", "person_firstname", "person_lastname", "person_birthdate", "person_code", "is_godfather", "modified_comment", "modified_on", "modified_by", "deleted");
        while (rs.next()) {
            result.add(new DomWeddingHistory(rs, cols));
        }
        rs.close();
        ps.close();
        return result;
    }
}

