/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.MPerson;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomUser;
import eelk.koguja.model.DomUserCongregation;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.UserExpression;
import eelk.koguja.search.UserResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MUser
extends Model<DomUser, UserExpression, UserResult> {
    private static MUser theInstance;

    protected MUser() {
    }

    public static MUser instance() {
        if (theInstance == null) {
            theInstance = new MUser();
        }
        return theInstance;
    }

    public static List<DomUser> listMyUsers() throws SQLException {
        String sql = "SELECT id, username, person_id, access_level, congregation_id   FROM v_my_users  WHERE admin_access = TRUE";
        PreparedStatement ps = Session.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        List<DomUser> lst = MUser.fromResultSet(rs, Util.createStringSet("id", "username", "person_id", "access_level", "congregation_id"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomUserCongregation> listUserCongregations(int userId) throws SQLException {
        ArrayList<DomUserCongregation> lst = new ArrayList<DomUserCongregation>();
        Set<String> cols = Util.createStringSet("congregation_id", "congregation_name", "user_id", "read_access", "write_access", "admin_access");
        String sql = " SELECT " + Util.setToStr(cols) + " FROM v_user_cong_admin_access  WHERE user_id = ?";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setObject(1, (Object)userId, 4);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            lst.add(new DomUserCongregation(rs, cols));
        }
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomPerson> congregationUsers(Integer cong_id, String firstName, String lastName) throws SQLException {
        String sql = "SELECT id, firstname, lastname, birthdate FROM v_cong_users_persons WHERE ";
        if (cong_id != null) {
            sql = sql + "congregation_id = ? AND ";
        }
        sql = sql + "LOWER(firstname) LIKE LOWER(?) AND LOWER(lastname) LIKE LOWER(?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        if (cong_id != null) {
            ps.setInt(1, cong_id);
            ps.setString(2, "%" + Util.d(firstName) + "%");
            ps.setString(3, "%" + Util.d(lastName) + "%");
        } else {
            ps.setString(1, "%" + Util.d(firstName) + "%");
            ps.setString(2, "%" + Util.d(lastName) + "%");
        }
        ResultSet rs = ps.executeQuery();
        List<DomPerson> lst = MPerson.fromResultSet(rs, Util.createStringSet("id", "firstname", "lastname", "birthdate"));
        rs.close();
        ps.close();
        return lst;
    }

    public static int setUserCong(List<DomUserCongregation> list) throws SQLException {
        if (list == null || list.isEmpty()) {
            return 0;
        }
        String sql = "{call set_user_cong(?,?,?)}";
        Integer permission = null;
        CallableStatement cs = Session.prepareCall(sql);
        for (DomUserCongregation object : list) {
            cs.setObject(1, (Object)object.getUserId(), 4);
            cs.setObject(2, (Object)object.getCongregationId(), 4);
            permission = null;
            if (object.isReadAccess()) {
                permission = 0;
            }
            if (object.isWriteAccess()) {
                permission = 1;
            }
            if (object.isAdminAccess()) {
                permission = 2;
            }
            cs.setObject(3, (Object)permission, 4);
            cs.execute();
        }
        cs.close();
        Session.connection().commit();
        return 0;
    }

    public static List<DomUser> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomUser> result = new ArrayList<DomUser>();
        while (rs.next()) {
            result.add(new DomUser(rs, fields));
        }
        return result;
    }

    @Override
    public int create(DomUser object) throws SQLException {
        String sql = "{? = call create_user(?,?,?,?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getCongregationId(), 4);
        cs.setObject(3, (Object)object.getPersonId(), 4);
        cs.setString(4, object.getUsername());
        if (object.getAccessLevel() == 1) {
            cs.setObject(5, (Object)true, 16);
        } else {
            cs.setObject(5, (Object)false, 16);
        }
        cs.setString(6, object.getPassword());
        cs.execute();
        int id = cs.getInt(1);
        cs.close();
        return id;
    }

    @Override
    public DomUser get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    @Override
    public void modify(DomUser object) throws SQLException {
        String sql = "{? = call modify_user(?,?,?,?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getId(), 4);
        cs.setString(3, Util.c(object.getPassword()));
        cs.setObject(4, (Object)object.getCongregationId(), 4);
        cs.setObject(5, (Object)object.getPersonId(), 4);
        if (object.getAccessLevel() == 1) {
            cs.setObject(6, (Object)true, 16);
        } else {
            cs.setObject(6, (Object)false, 16);
        }
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{call delete_user(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setObject(1, (Object)objectID, 4);
        cs.execute();
        cs.close();
    }

    @Override
    public List<UserResult> search(UserExpression expression) throws SQLException {
        return null;
    }
}

