/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomRole;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.RoleExpression;
import eelk.koguja.search.RoleResult;
import eelk.koguja.util.Util;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MRole
extends Model<DomRole, RoleExpression, RoleResult> {
    private static MRole theInstance;

    private MRole() {
    }

    public static MRole instance() {
        if (theInstance == null) {
            theInstance = new MRole();
        }
        return theInstance;
    }

    public static List<DomRole> listRoles() throws SQLException {
        String sql = "SELECT id, name FROM v_roles";
        PreparedStatement ps = Session.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        List<DomRole> lst = MRole.fromResultSet(rs, Util.createStringSet("id", "name"));
        rs.close();
        ps.close();
        return lst;
    }

    public static List<DomRole> fromResultSet(ResultSet rs, Set<String> fields) throws SQLException {
        ArrayList<DomRole> result = new ArrayList<DomRole>();
        while (rs.next()) {
            result.add(new DomRole(rs, fields));
        }
        return result;
    }

    @Override
    public int create(DomRole object) throws SQLException {
        String sql = "{? = call create_role(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setString(2, object.getName());
        cs.execute();
        int id = cs.getInt(1);
        cs.close();
        return id;
    }

    @Override
    public DomRole get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    @Override
    public void modify(DomRole object) throws SQLException {
        String sql = "{? = call modify_role(?,?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)object.getId(), 4);
        cs.setString(3, object.getName());
        cs.execute();
        cs.close();
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
        String sql = "{? = call delete_role(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 4);
        cs.setObject(2, (Object)objectID, 4);
        cs.execute();
        cs.close();
    }

    @Override
    public List<RoleResult> search(RoleExpression expression) throws SQLException {
        return null;
    }
}

