/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.dao;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.model.DomRelationship;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.RelationshipExpression;
import eelk.koguja.search.RelationshipResult;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class MRelationship
extends Model<DomRelationship, RelationshipExpression, RelationshipResult> {
    private static MRelationship theInstance;

    private MRelationship() {
    }

    public static MRelationship instance() {
        if (theInstance == null) {
            theInstance = new MRelationship();
        }
        return theInstance;
    }

    public static List<DomRelationship> listMyRelationships(Integer personId) throws SQLException {
        ArrayList<DomRelationship> lst = new ArrayList<DomRelationship>();
        String sql = "SELECT * FROM v_relationships";
        if (personId != null) {
            sql = sql + " WHERE person1_id = ? or  person2_id = ?";
        }
        PreparedStatement ps = Session.prepareStatement(sql);
        if (personId != null) {
            ps.setObject(1, (Object)personId, 4);
            ps.setObject(2, (Object)personId, 4);
        }
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            lst.add(new DomRelationship(rs));
        }
        rs.close();
        ps.close();
        return lst;
    }

    @Override
    public int create(DomRelationship relationship) throws SQLException {
        return 0;
    }

    @Override
    public DomRelationship get(int objectID) throws SQLException, ObjectNotFound {
        return null;
    }

    public DomRelationship get(int person1Id, int person2Id) throws SQLException {
        String sql = "SELECT * FROM f_get_relationship(?, ?)";
        PreparedStatement ps = Session.prepareStatement(sql);
        ps.setInt(1, person1Id);
        ps.setInt(2, person2Id);
        ResultSet rs = ps.executeQuery();
        DomRelationship result = null;
        if (rs.next()) {
            result = new DomRelationship(rs);
        }
        rs.close();
        ps.close();
        return result;
    }

    public void set(DomRelationship relationship) throws SQLException {
        String sql = "{call set_relationship(?, ?, ?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, Session.congregation().getId());
        if (relationship.getPerson1Id() == null) {
            cs.setNull(2, 4);
        } else {
            cs.setInt(2, (int)relationship.getPerson1Id());
        }
        if (relationship.getPerson2Id() == null) {
            cs.setNull(3, 4);
        } else {
            cs.setInt(3, (int)relationship.getPerson2Id());
        }
        if (relationship.getTypeId() == null) {
            cs.setNull(4, 4);
        } else {
            cs.setInt(4, (int)relationship.getTypeId());
        }
        cs.setString(5, relationship.getComment());
        cs.execute();
        cs.close();
    }

    @Override
    public void modify(DomRelationship object) throws SQLException {
    }

    @Override
    public void delete(int objectID) throws SQLException, ObjectNotFound {
    }

    @Override
    public List<RelationshipResult> search(RelationshipExpression expression) throws SQLException {
        return null;
    }

    public void end(int person1Id, int person2Id) throws SQLException {
        String sql = "{call end_relationship(?, ?, ?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.setInt(1, Session.congregation().getId());
        cs.setInt(2, person1Id);
        cs.setInt(3, person2Id);
        cs.execute();
        cs.close();
    }
}

